#include <xvinclude.h>

/*
 *  This program creates a read-only large text object 
 *  in which a file is displayed.
 */
static void test_text_cb PROTO ((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	char     *filename = "$DESIGN/repos/Aliases";
	xvobject manager;
	xvobject text;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

        /* initialize the xvwidget library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the manager backplane */
        manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
			   XVW_CHAR_WIDTH, 80.0,
			   XVW_CHAR_HEIGHT, 30.0,
			   NULL);

	/*
	 *  create the text object.  tack all its edges to it's manager
         *  parent, so that it will grow if the manager is resized.
         *  use XVW_TEXT_TYPE to indicate that the text object will be 
         *  displaying a file, and use XVW_TEXT_STRING to indicate which file.
	 */
	text = xvw_create_text(manager, "text");
	xvw_set_attributes(text,
		XVW_TACK_EDGE,      KMANAGER_TACK_ALL,
		XVW_TEXT_MULTILINE, TRUE,
		XVW_TEXT_TYPE,      KTEXT_TYPE_FILE,
		XVW_TEXT_STRING,    filename,
		NULL);
	
	/* display & run program */
	xvf_run_form();
}
