#include <xvinclude.h>

/*
 *  This example demonstrates the use of scrollbars; it uses
 *  both client_data and call_data.
 *
 *  The program creates two vertical scrollbars, and installs
 *  a callback on each which will cause the other scrollbar to
 *  change it's value by the same amount in the opposite direction
 *  when one of the scrollbars is moved.  
 */

void scrollbar_cb PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager, scroll1, scroll2;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "example", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create the manager backplane, 200x512 (pixels) */
	manager = xvw_create_manager(NULL, "manager");
	xvw_set_attributes(manager,
	                   XVW_WIDTH,  200,
	                   XVW_HEIGHT, 512,
	                   NULL);

	/*
	 *  create the first vertical scrollbar, values 0 to 100,
         *  2 characters wide, tacked to top & bottom, & centered
	 */
	scroll1 = xvw_create_scrollbar(manager, "scroll1");
        xvw_set_attributes(scroll1,
              XVW_ORIENTATION,  KSCROLLBAR_ORIENT_VERT, /* vert. scrollbar */
              XVW_CHAR_WIDTH,   2.0,                  /* 2 chars wide      */
              XVW_SCROLL_MIN,   0.0,                  /* min value 0       */
              XVW_SCROLL_MAX,   100.0,                /* max value  100    */
              XVW_SCROLL_VALUE, 10.0,                 /* value = 10        */
              XVW_TACK_EDGE,    KMANAGER_TACK_VERT,   /* tack vertically   */
              XVW_RIGHT_OF,     NULL,                 /* center            */
              XVW_LEFT_OF,      NULL,
              NULL);

	/*
	 *  create the second vertical scrollbar, values 0 to 100,
         *  2 characters wide, tacked to top & bottom, & R of 1st scrollbar
	 */
	scroll2 = xvw_create_scrollbar(manager, "scroll2");
        xvw_set_attributes(scroll2,
              XVW_ORIENTATION,  KSCROLLBAR_ORIENT_VERT, /* vert. scrollbar */
              XVW_RIGHT_OF,     scroll1,                /* R of 1st sb     */
              XVW_CHAR_WIDTH,   2.0,                    /* 2 chars wide    */
              XVW_SCROLL_MIN,   0.0,                  /* min value 0       */
              XVW_SCROLL_MAX,   100.0,                  /* max value 100   */
              XVW_SCROLL_VALUE, 90.0,                   /* value = 10      */
              XVW_TACK_EDGE,    KMANAGER_TACK_VERT,     /* tack vertically */
              NULL);

	/* add the scrollbar callback on both scrollbars.  */
        xvw_add_callback(scroll1, XVW_SCROLL_CONT_MOTION, 
	                 scrollbar_cb, scroll2);
        xvw_add_callback(scroll2, XVW_SCROLL_CONT_MOTION, 
                         scrollbar_cb, scroll1);

	/* display & run program */
	xvf_run_form();
}


/*
 *  the scrollbar callback will print out the current value of the scrollbar,
 *  and reverse the value of the other scrollbar
 */
void scrollbar_cb (
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	double value;
	double *movement = (double *) call_data;
	xvobject othersb = (xvobject) client_data;
	
	xvw_get_attribute(object, XVW_SCROLL_VALUE, &value);
	kfprintf(kstderr, "value = %f\n", value);
	kfprintf(kstderr, "movement = %f\n", *movement);
	value = 100.0 - value;
	xvw_set_attribute(othersb, XVW_SCROLL_VALUE, value);
}

