#include <xvinclude.h>

/*
 *  This program demonstrates the use of xvu_query_wait to pop up a 
 *  query object in which the user can respond by entering values as 
 *  instructed.  It gives two examples:  the first example uses the
 *  query object to prompt the user for a float constant (no default), 
 *  and the second example uses the query object to prompt the user for
 *  a set of labels.
 */

static void query1_cb PROTO((xvobject, kaddr, kaddr));
static void query2_cb PROTO((xvobject, kaddr, kaddr));
static void quit_cb   PROTO((xvobject, kaddr, kaddr));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
        xvobject button1, button2;
        xvobject quit;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager object backplane for a button */
	manager = xvw_create_manager(NULL, "manager");
	xvw_set_attributes(manager,
			   XVW_WIDTH,  200,
			   XVW_HEIGHT, 200,
		           NULL);

	/*
	 *  create a yellow button at the left side of the manager;
         *  install a callback which will display the first example of query.
	 */
	button1 = xvw_create_button(manager, "button1");
	xvw_set_attributes(button1,
			   XVW_LABEL,            "Query1",
			   XVW_BACKGROUND_COLOR, "yellow",
			   XVW_RIGHT_OF,          NULL,
			   XVW_ABOVE,             NULL,
			   XVW_BELOW,             NULL,
			   NULL);
	xvw_add_callback(button1, XVW_BUTTON_SELECT, query1_cb, NULL);

	/*
	 *  create a blue button next to the first button;
         *  install a callback which will display the second example of query.
	 */
	button2 = xvw_create_button(manager, "button");
	xvw_set_attributes(button2,
			   XVW_LABEL,            "Query2",
			   XVW_BACKGROUND_COLOR, "slateblue",
			   XVW_RIGHT_OF,          button1,
			   XVW_ABOVE,             NULL,
			   XVW_BELOW,             NULL,
			   NULL);
	xvw_add_callback(button2, XVW_BUTTON_SELECT, query2_cb, NULL);

	/* create a quit button, just to be fancy.  */
	quit = xvw_create_button(manager, "quit");
        xvw_set_attributes(quit,
                           XVW_LABEL,            "quit",
                           XVW_LEFT_OF,           NULL,
                           XVW_BELOW,             NULL,
                           NULL);
	xvw_add_callback(quit, XVW_BUTTON_SELECT, quit_cb, NULL);

	/* display and run the program.  */
	xvf_run_form();
}

/*
 *  callback to display first example of query object:
 *  this example prompts the user for a single float value.
 */
static void query1_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	char  *label        = "Please enter a floating point constant";
	char  *button_label = "Use";
	char  *prompts[1]   = {"value:"};
	int   num_prompts   = 1;
	char  **answers;
	int   size, status;
	float constant;

	/* size to make the text parameter box (in characters) */
	size = 30;

	/* allocate the answers array: size 1, no default */
	answers = (char **) kcalloc(1, sizeof(char *));

	*answers = NULL;
	
	status = xvu_query_wait(label, prompts, button_label, 
	                        answers, num_prompts, size);
	if (status == 0)
	   kfprintf(kstderr, "User cancelled query\n");
	else 
	{
	    if (answers[0] != NULL)
	    {
	        constant = atof(answers[0]);
	        kfprintf(kstderr, "User entered constant %f\n", constant);
	    }
	    else kfprintf(kstderr, 
			 "User did not enter anything, but hit 'use' anyway\n");
	}
	kfree(answers);

}

/*
 *  callback to display second example of query object
 */
static void query2_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
        char  *label        = "Please personalize these labels";
        char  *button_label = "ok";
        char  *prompts[]    = {"label1:",
			       "label2:",
			       "label3:",
			       "label4:",
			       "label5:"};
        int   i, num_prompts;
        char  **answers;
        int   size, status;
        float constant;

        /* size to make the text parameter box (in characters) */
        size = 50;
	num_prompts = knumber(prompts);

        /* allocate the answers array */
        answers = (char **) kcalloc(num_prompts, sizeof(char *));
	
        /* initialize the answers array */
	for (i = 0; i < num_prompts; i++)
	    answers[i] = kstrdup("test");

        status = xvu_query_wait(label, prompts, button_label,
                                answers, num_prompts, size);
        if (status == 0)
           kfprintf(kstderr, "User cancelled query\n");
        else
        {
	    for (i = 0; i < num_prompts; i++)
	    {
                if (answers[i] != NULL)
                    kfprintf(kstderr, "for %s, user entered %s\n", 
			     prompts[i], answers[i]);
		else kfprintf(kstderr, "for %s, user entered NULL\n", 
			      prompts[i]); 
	    }
        }
	kfree(answers);
}


/*
 *  callback to quit
 */
static void quit_cb(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
	kexit(KEXIT_SUCCESS);
}
