#include <xvinclude.h>

/*
 * This example demonstrates the four uses of xvu_run_list_multsel_wait().
 *
 *  First, a list is popped up from which the user may choose one or more 
 *  of the fruits provided. They may select each fruit only once (selected
 *  fruits are marked with a star), and may not provide their own list entry.  
 *  When finished, the user may click on "Use";  user's selections are printed.
 *
 *  Second, a list is popped up from which the user may choose one or more
 *  of the veggies provided. They may select each veggie only once (selected 
 *  items are marked with a star), but they may provide their own vegetable
 *  by entering a string in the text parameter box and hitting <cr>, which 
 *  adds the new string to the list.   They may then select their newly defined
 *  vegetable.  As many user-defined items may be created and selected as
 *  desired.  When finished, the user may click on "Use";  choices are printed.
 *
 *  Third, a list is popped up from which the user may choose one or more
 *  of the meats provided. They may select each meat as many times as they
 *  like (selected meats are marked with with the number of times they have
 *  been selected), but they may not provide their own list entry.
 *  When finished, the user may click on "Use";  choices are printed.
 *
 *  Fourth, a list is popped up from which the user may choose one or more
 *  of the noodles provided. They may select each noodle as many times as they
 *  like (selected noodles are marked with with the number of times they have
 *  been selected).  In addition, they  but they may provide their own noodle
 *  entry by entering a string in the text parameter box and hitting <cr>, which
 *  adds the new string to the list.   They may then select their newly defined
 *  list item as many times as they like; choices are printed.
 *
 */


void main(
   int  argc,
   char **argv,
   char **envp)
{
        int i, num_choices, default_index, user_defined, duplicates_ok;
        xvw_list_struct **list_return;
 
        static char *prompt1 = "Pick some fruit";
        static char *prompt2 = "Pick some veggies, and/or provide your own";
        static char *prompt3 = "Pick some meat";
        static char *prompt4 = "Pick some noodles, and/or provide your own";
        static char *label  = "Available";
        static char *fruit[]   = { "Apples", "Oranges", "Bananas", "Peaches",
                                   "Limes", "Lemons", "Papayas", "Mangoes" };
        static char *veggies[] = { "Carrot", "Celery", "Cucumber", "Tomato",
                                   "Onion",  "Radish", "Cabbage", "Corn" };
        static char *meat[]    = { "Ground Round", "Flank Steak", "Pot Roast",
				   "Pork Loin", "Filet Mignon",  "T bone", 
                                   "Italian Sausage", 
				   "Rocky Mountain Oysters" };
        static char *noodles[] = { "Fettucine", "Rigatoni", "Capellini",
				   "Macaroni",  "Spagettini",  "Lasagna", 
                                   "Manicotti", "Pastina" };
 
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
         *  pop up the first list widget; this one does NOT allow
         *  the user to provide their own choice.  It only allows the
         *  user to choose any particular item once.
         */
	user_defined  = FALSE;
	duplicates_ok = FALSE;

	kfprintf(kstderr, "\n\n------- List 1 -----------\n");
	kfprintf(kstderr, "user defined strings: no\n"); 
	kfprintf(kstderr, "duplicate selections: no\n\n"); 
        list_return = xvu_run_list_multsel_wait(fruit, knumber(fruit), 
					        prompt1, label, 
                                                user_defined, duplicates_ok, 
				                &num_choices);
	if (num_choices == 0)
	    kfprintf(kstderr, "No choices made.\n");
	else kfprintf(kstderr, "Choice made were:\n");
        for (i = 0; i < num_choices; i++)
            kfprintf(kstderr, "%s\n", list_return[i]->string);
 
        /*
         *  pop up the second list widget; this one DOES allow
         *  the user to provide their own choice.  It only allows the
         *  user to choose any particular item once.
         */
        user_defined  = TRUE;
        duplicates_ok = FALSE;

        kfprintf(kstderr, "\n\n------- List 2 -----------\n");
        kfprintf(kstderr, "user defined strings: yes\n"); 
        kfprintf(kstderr, "duplicate selections: no\n\n");
        list_return = xvu_run_list_multsel_wait(veggies, knumber(veggies), 
                                                prompt2, label,
                                                user_defined, duplicates_ok, 
                                                &num_choices);
	if (num_choices == 0)
	    kfprintf(kstderr, "No choices made.\n");
	else kfprintf(kstderr, "Choice made were:\n");
        for (i = 0; i < num_choices; i++)
            kfprintf(kstderr, "%s\n", list_return[i]->string);


        /*
         *  pop up the third list widget; this one does NOT allow
         *  the user to provide their own choice.  It allows the
         *  user to choose any item as often as they want.
         */
        user_defined  = FALSE;
        duplicates_ok = TRUE;

        kfprintf(kstderr, "\n\n------- List 3 -----------\n");
        kfprintf(kstderr, "user defined strings: no\n"); 
        kfprintf(kstderr, "duplicate selections: yes\n\n");
        list_return = xvu_run_list_multsel_wait(meat, knumber(meat), 
                                                prompt3, label,
                                                user_defined, duplicates_ok, 
                                                &num_choices);
	if (num_choices == 0)
	    kfprintf(kstderr, "No choices made.\n");
	else kfprintf(kstderr, "Choice made were:\n");
        for (i = 0; i < num_choices; i++)
            kfprintf(kstderr, "%s\n", list_return[i]->string);


        /*
         *  pop up the fourth list widget; this one DOES allow
         *  the user to provide their own choice.  It allows the
         *  user to choose any item as often as they want.
         */
        user_defined  = TRUE;
        duplicates_ok = TRUE;

        kfprintf(kstderr, "\n\n------- List 4 -----------\n");
        kfprintf(kstderr, "user defined strings: yes\n"); 
        kfprintf(kstderr, "duplicate selections: yes\n\n");
        list_return = xvu_run_list_multsel_wait(noodles, knumber(noodles), 
                                                prompt4, label,
                                                user_defined, duplicates_ok, 
                                                &num_choices);
	if (num_choices == 0)
	    kfprintf(kstderr, "No choices made.\n");
	else kfprintf(kstderr, "Choice made were:\n");
        for (i = 0; i < num_choices; i++)
            kfprintf(kstderr, "%s\n", list_return[i]->string);


	kexit(KEXIT_SUCCESS);
}
