#include <xvinclude.h>

/*
 *  This example shows how a file browser is created and run.
 *  Note that the file browser will stop the calling application
 *  until the user chooses a file or clicks on "Cancel".
 */
void main(
   int  argc,
   char **argv,
   char **envp)
{
	char *filename; 
	char *directory = "./";

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 * create & run the browser.  xvu_run_browser() will return
         * the name of the chosen file on success, NULL on failure
	 */
	filename = xvu_run_browser(directory);

	if (filename == NULL)
	   kfprintf(kstderr, "\nBrowser cancelled...\n");
	else kfprintf(kstderr, "\nFile choosen: '%s'\n", filename);

	kexit(KEXIT_SUCCESS);
}
