#include <xvinclude.h>


/*
 *  This example shows how a layout object can be used to lay out
 *  a number of area objects (containing plot objects) neatly without 
 *  explicit location specification.
 *
 *  An "Add Another Plot" button underneath invokes a callback which
 *  creates a new area object within the layout object.
 */

#define MAXPLOTS 8
char *filename = "plot2d:cosine";

static void add_another PROTO((xvobject, kaddr, kaddr));
static void create_area PROTO((xvobject));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	int      i, degrees;
	xvobject parent, layout, button;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "ENVISION");

	/* initialize the xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
	   kerror(NULL, "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
        }

	/*
	 * create manager to be parent of layout & button
	 */
	parent = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(parent,
		    XVW_MINIMUM_WIDTH,             170,
		    XVW_MINIMUM_HEIGHT,	           170,
		    NULL);

	/* create button so the user can create a new plot inside the layout */
	button = xvw_create_button(parent, "button");
	xvw_set_attributes(button, 
			   XVW_LABEL,   "New Plot",
			   XVW_ABOVE,    NULL,
			   XVW_RIGHT_OF, NULL,
			   XVW_LEFT_OF,  NULL,
			   NULL);

        /*
         * create the layout object
         */
        layout = xvw_create_layout(parent, "Layout"); 
	xvw_set_attributes(layout,
		    XVW_ABOVE,   		   button,
		    XVW_TACK_EDGE,   		   KMANAGER_TACK_ALL,
                    XVW_LAYOUT_BUFFER_SIZE,        3,
                    XVW_LAYOUT_NUMBER_ACROSS,      2,
                    XVW_LAYOUT_AREA_JUSTIFICATION, KLAYOUT_AREA_CENTER,
		    NULL);

	/* call subroutine to create first plot object */
	create_area(layout);

	/* add the "add_another" callback to the button */
	xvw_add_callback(button, XVW_BUTTON_SELECT, add_another, layout);

	/* display and run */
	xvf_run_form();
}

/*
 *  This is the callback that creates a new plot inside the layout object
 *  when the user clicks on the "New Plot" button.
 */
static void add_another(
   xvobject object,
   kaddr    client_data,
   kaddr    call_data)
{
        char     string[KLENGTH];
	xvobject layout = (xvobject) client_data;
	static   int count = 1;

        if (count++ >= MAXPLOTS )
            kinfo(KSTANDARD, "No more than %d plots allowed", MAXPLOTS );
        else create_area(layout);
}

/*
 *  this subroutine creates an area object with a plot inside
 */
static void create_area(
     xvobject layout)
{
	xvobject plot, area;

	area = xvw_create_area(layout, "area");
        xvw_set_attributes(area,
                     XVW_AREA_DISPLAY_TITLE, FALSE,
                     XVW_AREA_DISPLAY_DATE,  FALSE,
                     NULL);

	/* create the plot object; set plot file and color */
        plot = xvw_create_plot2d(area, "plot");
        xvw_set_attributes(plot,
		     XVW_AREA_ATTACH,      area,
                     XVW_PLOT2D_PLOTFILE,  filename,
                     XVW_FOREGROUND_COLOR, "white",
                     NULL);
}
