#include <xvinclude.h>

/*
 *  This example creates a canvas object;  it then creates two label
 *  widgets on the canvas; one at the top, one at the bottom.
 *
 *  This program loads the sample appdefaults file example.appdefaults
 *  which sets the background pixmap to <blah>...
 */
static void quit_program PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject canvas, label, button;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Load an app-defaults file
	 */
	xvw_load_resources("./example.appdefaults");


	/*
	 *  Create the canvas.  Note that since the parent is NULL, a
	 *  toplevel window will be created and the canvas placed inside.
         *  Set the canvas to be 512x512 (pixels) with a grid size of 20.
	 */
	canvas = xvw_create_canvas(NULL, "canvas");
	xvw_set_attributes(canvas,
		XVW_WIDTH,  512,
		XVW_HEIGHT, 512,
		NULL);

	/* put a label near the top of the canvas */
/*
	label = xvw_create_label(canvas, "label1");
	xvw_set_attributes(label,
		           XVW_LABEL,    "This is a sample label",
		           XVW_CHAR_XPOS, 10.0,
		           XVW_CHAR_YPOS, 10.0,
		           NULL);
 */

	/*
	 *  put a button to the right of the label;
         *  install callback so user can change background
	 */
/*
	button = xvw_create_button(canvas, "button");
	xvw_set_attributes(button,
			   XVW_LABEL,    "Quit",
                           XVW_CHAR_XPOS, 40.0,
                           XVW_CHAR_YPOS, 10.0,
			   NULL);
	xvw_add_callback(button, XVW_BUTTON_SELECT, quit_program, canvas);
 */

	/* put another label way down the canvas as well.  */
/*
	label = xvw_create_label(canvas, "label1");
	xvw_set_attributes(label,
		XVW_LABEL, "This is a sample label",
		XVW_CHAR_XPOS, 10.0,
		XVW_CHAR_YPOS, 40.0,
		XVW_CHAR_WIDTH, (float) kstrlen("This is a sample label"),
		NULL);
 */

	/* and we're off! */
	xvf_run_form();
}

static void quit_program(
    xvobject object,
    kaddr    client_data,
    kaddr    call_data)
{
   xvw_destroy(xvw_toplevel(object));
}

