#include <xvinclude.h>

/*
 *  This example creates an error object to display an error message.
 *
 *  IMPORTANT NOTE: in general, the error object should *not* be created
 *                  directly;  use of kerror() is the conventional way to 
 *                  create messages in Khoros, so that there is standard
 *                  formatting enforced.  this example is really only for
 *                  academic purposes.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject error;
	xvobject toplevel;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/*
	 *  Create the error object. Note since the parent is NULL, a
	 *  toplevel window will be created and the error object placed
	 *  inside.   Set the label, the message, the button label.
	 */
	error = xvw_create_error(NULL, "Error Message");
	xvw_set_attributes(error,
		XVW_ERROR_LABEL,   "ERROR, ERROR! ZZZZT!  ZZZZT",
		XVW_ERROR_MESSAGE, "This is a test of the error object.  This is only a test.  If this had been an actual error, you would have received a seg fault and maybe even a core dump.",
		XVW_ERROR_BUTTON_LABEL, "Ooops",
		NULL);

	/* display and run the program.  */
	xvf_run_form();
}
