#include <xvinclude.h>

/*
 *  This example creates a simple inputfile GUI object, which may
 *  be used for allowing the user to enter a input file.  The user may
 *  enter a value in the text parameter box, or click on the label button,
 *  which will bring up the file browser from which a file may be picked.
 *
 *  A callback is installed on the input file object so that when the 
 *  user changes the value of the input file, the current 
 *  filename is printed to the tty.
 *
 *  Note that the input file object should *not* be created directly in an 
 *  xvroutine, as use of the InputFile (-I) UIS line in the *.form file is 
 *  both easier to use and a more standard use of the Khoros system.  
 *  However, the inputfile object is provided for use with hybrid xvroutines, 
 *  (such as this example) which do not use a "formalized" GUI as defined 
 *  in a *.form file.
 */
static void inputfile_cb PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane for the inputfile object */
	manager = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(manager,
			   XVW_WIDTH,       300,
		           XVW_HEIGHT,      100,
			   NULL);

	/*
         *  Create the inputfile object.  give it a label.
         *  tack it horizontally to the parent so that it spans the
         *  width of the manager backplane.  center it in the middle of
         *  the parent.
	 */
	object = xvw_create_inputfile(manager, "inputfile");
	xvw_set_attributes(object,
		XVW_INPUTFILE_LABEL,     "Input File",
		XVW_INPUTFILE_FILENAME,  "image:ball",
		XVW_TACK_EDGE,           KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	         NULL,
		XVW_BELOW,	         NULL,
		NULL);
	xvw_add_callback(object, XVW_INPUTFILE_CALLBACK, inputfile_cb, NULL);

	/* display & run the program */
	xvf_run_form();
}

/*
 *  the callback for the inputfile will be fired when the user changes the
 *  value of the input file & hits <cr>, or when they use the browser to choose
 *  a file.  this callback simply prints the current filename.
 */
static void inputfile_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	char *filename;

	xvw_get_attribute(object, XVW_INPUTFILE_FILENAME, &filename);
	kfprintf(kstderr, "Filename = %s\n", filename);
}

