#include <xvinclude.h>

/*
 *  This example creates a simple float GUI object, which may
 *  be used for allowing the user to enter a float.  
 *
 *  A callback is installed on the float object so that when the 
 *  user changes the value of the float either by entering a number
 *  in the text parameter box and hitting <cr> or by using the scrollbar,
 *  the current value is printed to the tty.
 *
 *  Note that the float object should *not* be created directly in an 
 *  xvroutine, as use of the Float (-f) UIS line in the *.form file is 
 *  both easier to use and a more standard use of the Khoros system.  
 *  However, the float object is provided for use with hybrid xvroutines, 
 *  (such as this example) which do not use a "formalized" GUI as defined 
 *  in a *.form file.
 */
static void float_cb PROTO((xvobject, kaddr, kaddr));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject manager;
	xvobject object;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror(NULL, "main", "unable to open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane to be a parent for the float object */
	manager = xvw_create_manager(NULL, "parent");
	xvw_set_attributes(manager,
			   XVW_WIDTH,       300,
		           XVW_HEIGHT,      100,
			   NULL);

	/*
         *  Create the float object.  give it a label, a default value,
         *  and bound it with a minimum value of 0 and a maximum value of
         *  255.  tack it horizontally to the parent so that it spans the
         *  width of the manager backplane.  center it in the middle of
         *  the parent.
	 */
	object = xvw_create_float(manager, "float");
	xvw_set_attributes(object,
		XVW_FLOAT_LABEL,    "Float Number",
		XVW_FLOAT_VALUE,     123.456,
		XVW_FLOAT_MINVALUE,  0.0,
		XVW_FLOAT_MAXVALUE,  255.0,
		XVW_TACK_EDGE,       KMANAGER_TACK_HORIZ,
		XVW_ABOVE,	     NULL,
		XVW_BELOW,	     NULL,
		NULL);
	xvw_add_callback(object, XVW_FLOAT_CALLBACK, float_cb, NULL);

	/* display & run the program */
	xvf_run_form();
}

/*
 *  the callback for the float will be fired when the user changes the
 *  value of the float, either by using the scrollbar or by entering
 *  a value in the text parameter box & hitting <cr>.  this callback simply
 *  prints the current value of the float.
 */
static void float_cb(
    xvobject object,
    kaddr client_data,
    kaddr call_data)
{
	float value;

	xvw_get_attribute(object, XVW_FLOAT_VALUE, &value);
	kfprintf(kstderr, "Value = %f\n", value);
}

