#include <xvinclude.h>

/*
 * This example brings up a finderlist and allows you to search it.
 */
void callback(xvobject obj, kaddr client, kaddr calldata)

{
	xvobject finderlist = (xvobject) client;
	char *expr = *((char **) calldata);

	xvw_set_attribute(finderlist, XVW_FINDERLIST_EXPRESSION, expr);
}

main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject parent, finderlist, text;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "unable to open display");
	   kexit(1);
	}

	parent = xvw_create_manager(NULL, "finderlist");
	xvw_set_attributes(parent,
                XVW_MINIMUM_WIDTH,  400,
                XVW_MINIMUM_HEIGHT, 250,
                NULL);

	text = xvw_create_textinput(parent, "text");
        xvw_set_attributes(text,
		XVW_ABOVE, NULL,
		XVW_TACK_EDGE, KMANAGER_TACK_HORIZ,
		NULL);

	/*
	 *  Create the workspace.  Note that since the parent is NULL, a
	 *  toplevel window will be created and the workspace display placed
	 *  inside.  The XVW_WORKSPACE_RESTORE attribute is used to specify 
         *  the workspace file to be restored.
	 */
	finderlist = xvw_create_finderlist(parent, "finderlist");
        xvw_set_attributes(finderlist,
		XVW_TACK_EDGE, KMANAGER_TACK_ALL,
		XVW_ABOVE, text,
                NULL);
	xvw_add_callback(text, XVW_TEXTINPUT_CALLBACK, callback, finderlist);

	/* display & run the program */
	xvf_run_form();
}

