#include <xvinclude.h>

/*
 *  This program illustrates a combination of tacking and relative layout.
 *  The "left", "middle", and "right" buttons use relative layout so that
 *  they are always located in the center, middle, and right (regardless of
 *  geometry change initiated with window manager).  The manager object that
 *  is created below the buttons is tacked, so that the manager grows if the
 *  toplevel object is resized with the window manager.
 *
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
	xvobject manager;
	xvobject left, right, middle, workspace, zoom;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");
	
	/* initialize the xvwidgets lib */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	/* create a manager object backplane: this one is 512x512 pixels */
	manager = xvw_create_manager(NULL, "back");

	/* create buttons for left, right, top, and bottom */
	left   = xvw_create_button(manager, "left button");
	xvw_set_attributes(left,
		          XVW_LABEL,     " left ",
			  XVW_RIGHT_OF,  NULL,
			  NULL);

	right  = xvw_create_button(manager, "right button");
	xvw_set_attributes(right,
		          XVW_LABEL,     "right ",
			  XVW_LEFT_OF,   NULL,
			  NULL);

	middle = xvw_create_button(manager, "middle button");
	xvw_set_attributes(middle,
		          XVW_LABEL,     "middle",
			  XVW_LEFT_OF,   right,
			  XVW_RIGHT_OF,  left,
			  NULL);

	workspace = xvw_create_manager(manager, "parent");

	xvw_set_attributes(workspace,
                          XVW_BELOW,          middle,
                          XVW_TACK_EDGE,      KMANAGER_TACK_ALL,
			  XVW_MINIMUM_WIDTH,  200,
			  XVW_MINIMUM_HEIGHT, 200,
	                  XVW_RESIZABLE,      TRUE, 
                          XVW_DEF_HORIZ_DIST, 0,
                          XVW_DEF_VERT_DIST,  0,
			  XVW_SELECTABLE,     TRUE,
			  NULL);

	/* display & run program */
	xvf_run_form();
}
