#include <xvinclude.h>

/*
 * Similar to 04.layout/, this example uses 4 buttons each on the
 * top, right, bottom, and left.
 */

void main(
   int  argc,
   char **argv,
   char **envp)
{
	int      i;
	char	 name[KLENGTH];
	xvobject manager, left, right, bottom, top;
	xvobject previous_left, previous_right, previous_bottom, previous_top;
	
        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");
	
        /* initialize xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
	   kexit(KEXIT_FAILURE);
	}

	manager = xvw_create_manager(NULL, "back");
	xvw_set_attributes(manager,
	              XVW_WIDTH,  650,
	              XVW_HEIGHT, 650,
	              XVW_SELECTABLE, TRUE,
	              XVW_RESIZABLE, TRUE,
		      NULL);

	previous_left   =
	previous_right  =
	previous_top    =
	previous_bottom = NULL;
	for (i = 0; i < 4; i++)
	{
	   ksprintf(name, "left button '%d'", i);
	   left   = xvw_create_button(manager, name);
	   ksprintf(name, "right button '%d'", i);
	   right  = xvw_create_button(manager, name);
	   ksprintf(name, "top button '%d'", i);
	   top    = xvw_create_button(manager, name);
	   ksprintf(name, "bottom button '%d'", i);
	   bottom = xvw_create_button(manager, name);

	   xvw_set_attributes(left,
	   	      XVW_LABEL,     "left",
	   	      XVW_RIGHT_OF,   previous_left,
	   	      XVW_BELOW,      top,
	   	      XVW_ABOVE,      bottom,
		      XVW_TACK_EDGE,  KMANAGER_TACK_VERT,
	              XVW_SELECTABLE, TRUE,
	              XVW_RESIZABLE,  TRUE,
	   	      NULL);

	   xvw_set_attributes(right,
	   	      XVW_LABEL,     "right",
	   	      XVW_LEFT_OF,    previous_right,
	   	      XVW_BELOW,      top,
	   	      XVW_ABOVE,      bottom,
		      XVW_TACK_EDGE,  KMANAGER_TACK_VERT,
	              XVW_SELECTABLE, TRUE,
	              XVW_RESIZABLE,  TRUE,
	   	      NULL);

	   xvw_set_attributes(top,
	   	      XVW_LABEL,     "top",
	   	      XVW_BELOW,      previous_top,
	   	      XVW_RIGHT_OF,   left,
	   	      XVW_LEFT_OF,    right,
	   	      XVW_TACK_EDGE,  KMANAGER_TACK_HORIZ,
	              XVW_SELECTABLE, TRUE,
	              XVW_RESIZABLE,  TRUE,
	   	      NULL);

	   xvw_set_attributes(bottom,
	   	      XVW_LABEL,     "bottom",
	   	      XVW_ABOVE,      previous_bottom,
	   	      XVW_RIGHT_OF,   left,
	   	      XVW_LEFT_OF,    right,
	   	      XVW_TACK_EDGE,  KMANAGER_TACK_HORIZ,
	              XVW_SELECTABLE, TRUE,
	              XVW_RESIZABLE,  TRUE,
	   	      NULL);
	   previous_left   = left;
	   previous_right  = right;
	   previous_top    = top;
	   previous_bottom = bottom;
	}

	/*
	 * display & run program
	 */
	xvf_run_form();
}
