#include "xvinclude.h"

/*
 * This example illustrates how a timeout is used.
 */

void timeout PROTO((xvobject, kaddr, int *));

void main(
   int  argc,
   char *argv[],
   char *envp[])
{
	xvobject   manager;
	xvobject   labelstring;

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
	if (!xvw_initialize(XVW_MENUS_XVFORMS))
	{
	   kerror("example", "main", "Cannot open display");
           kexit(KEXIT_FAILURE);
	}

	/* create a manager backplane */
	manager = xvw_create_manager(NULL, "back");

	/* a single button on the manager */
	labelstring = xvw_create_labelstr(manager, "labelstring");
	xvw_set_attributes(labelstring, 
			   XVW_LABEL,  "0 seconds have passed",
			   XVW_FORCE_REDISPLAY, TRUE,
			   NULL);

	/* add callback to button */
	xvw_add_timeout(labelstring, 1.0, timeout, NULL);

	/* display and run */
	xvf_run_form();
}

/*
 * here's the timeout
 */
void timeout(
    xvobject object,     
    kaddr    client_data,
    int      *stop_timer)
{
	char   temp[KLENGTH];
	static int count = 1;

	ksprintf(temp, "%d seconds have passed", count++);
	xvw_set_attribute(object, XVW_LABEL, temp);
}
