#include "xvinclude.h"
#include "xvisual/xvisual.h"

void  quit_program PROTO((xvobject, kaddr, XEvent *, int *));

/*
 * This program creates an image visual object, 
 * reads the ball image into a data object, and displays the data object
 * in the visual object.  It then installs an event handler to exit the 
 * program when the user does a ButtonPress in the image.  The data object
 * is passed as the client data.
 */
main(
   int  argc,
   char *argv[],
   char *envp[])
{
	kobject  img_data_obj;   /* the image data object   */
        xvobject img_visual_obj; /* the image visual object */

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize xvwidgets lib */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create the xvobject to display the image */
        img_visual_obj = xvw_create_image(NULL, "image");

	/* read the ball image into a data object */
	img_data_obj = kpds_open_input_object("image:ball");

	/* associate the image data we just read in w/ the image xvobject */
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEOBJ, img_data_obj);

	/* 
	 * add the event handler to quit the program. The "img_data_obj"
         * kobject can be passed as the client data directly (without using
         * "&img_data_obj"), since a kobject is really a pointer.
         */
	xvw_add_event(img_visual_obj, ButtonPressMask, quit_program, 
                      img_data_obj);

	/* display & run */
        xvf_run_form();
}

/*
 * event handler allowing the user to quit program
 */
void  quit_program(
   xvobject object,
   kaddr    client_data,
   XEvent   *event,
   int      *dispatch)
{
	kobject  img_data_obj;  /* expected image data object */

	/* cast client_data to expected type */
	img_data_obj = (kobject) client_data; 

	/* don't need to pass the image visual object, it is passed anyway */
	xvw_destroy(object);

	/* now that the client_data has been cast, use it as desired */
	kpds_close_object(img_data_obj);

	/* exit the program */
        kexit(KEXIT_SUCCESS);
}
