#include <xvinclude.h>

/*
 * This program puts up an image of the ball.
 * An action handler allows the user to quit the program by pressing 'q'.
 */

void  quit_program PROTO((xvobject, kaddr, XEvent *));
void  invert_img   PROTO((xvobject, kaddr, XEvent *, Boolean *));

main(
   int  argc,
   char *argv[],
   char *envp[])
{
        xvobject img_visual_obj; /* the image visual object */

        /* initialize Khoros program */
        khoros_initialize(argc, argv, envp, "DESIGN");

	/* initialize the xvwidgets library */
        if (!xvw_initialize(XVW_MENUS_XVFORMS))
        {
           kerror(NULL, "main", "unable to open display");
           kexit(KEXIT_FAILURE);
        }

	/* create the visual object (default parent, default toplevel) */
        img_visual_obj = xvw_create_image(NULL, "image");

	/* specify the image to be displayed by filename */
        xvw_set_attribute(img_visual_obj, XVW_IMAGE_IMAGEFILE, "image:ball");

	/* 
	 * add the action handler to quit the program. The only information
         * needed is the visual object, which is passed to it anyway, as
         * the first parameter.
         */
	xvw_add_action(img_visual_obj, "<Key>q", quit_program, NULL, TRUE);

	/* display and run */
        xvf_run_form();
}

/*
 *  action handler to quit program on Key Press 'q'
 */
void  quit_program(
   xvobject object,       /* the image visual object */
   kaddr    client_data,  /* not used */ 
   XEvent   *event)       /* also not used - we know what the event was. */
{
        xvw_destroy(object);
        kexit(KEXIT_SUCCESS);
}

