#include <dataserv.h>

void test_callback(kobject o, char *segment, kaddr cd, kdms_callback *dta)
{
   kprintf("Got a callback: %s: \n",segment);
   kprintf("\t%s\n\tbegin = %d %d %d %d %d\n\tend = %d %d %d %d %d\n",
	 dta->segment,dta->begin.w,dta->begin.h,dta->begin.d,
	 dta->begin.t,dta->begin.e,dta->end.w,dta->end.h,dta->end.d,
	 dta->end.t,dta->end.e);
}

main()
{
   kobject o;
   int *idata;
   float *fdata;
   int i;

   int size[5] = {3,1,1,1,1};
   int begin[5] = { 0,0,0,0,0};
   int end[5] = {2,0,0,0,0};
   int order[5] = {KWIDTH,KHEIGHT,KDEPTH,KTIME,KELEMENTS};

   o = kdms_output("test.xv");

   kdms_create_segment(o,KDMS_SEGMENT_VALUE);
   kdms_set_attributes(o,KDMS_SEGMENT_VALUE,
	KDMS_DIMENSION, 1,
        KDMS_SIZE,      size,
        KDMS_INDEX_ORDER,	order,
	KDMS_DATA_TYPE,	KINT, NULL);

   idata = kdms_get_data(o,KDMS_SEGMENT_VALUE,begin,end,NULL);

   idata[0] = 1; idata[1] = 2; idata[2] = 3;
   kdms_put_data(o,KDMS_SEGMENT_VALUE,begin,end,idata);

   size[0] = 4;
   kdms_set_attributes(o,KDMS_SEGMENT_VALUE,
	KDMS_SIZE, size,
	KDMS_DATA_TYPE, KFLOAT, NULL);

   end[0] = 3;
   fdata = kdms_get_data(o,KDMS_SEGMENT_VALUE,begin,end,NULL);

   for (i=0;i<4;i++)
       kprintf("%f ",fdata[i]);
   kprintf("\n");

   kdms_close(o);
   kfree(idata);
   kfree(fdata);
   kexit(0);
}
