#include <dataserv.h>

#define FAIL(error)               \
        {                         \
          kinfo(KFORCE,error);    \
          kexit(KEXIT_FAILURE);   \
        }

main()
{
   kobject o;
   double *data = NULL;
   float   width[3]  = {-1.0, 1.0, 8.2};
   float   height[4] = {-99.0, 0.0, 8.2, 9.1};
   float   depth[2]  = {22.0, 8.1};
   
   int i;
   int w;
   int h;
   int d;

   o = kpds_open_output_object("utest.xv");

   kprintf("\n\n////UNIFORM TEST\n"); 
   /* -- create some uniform location -- */
   kpds_set_attribute(o, KPDS_LOCATION_GRID, KUNIFORM);
   kpds_create_location(o);

   kpds_set_attributes(o, KPDS_LOCATION_DATA_TYPE, KDOUBLE,
	 		  KPDS_LOCATION_SIZE, 3, 4, 4, 3,
		          NULL);

   /* -- set the uniform begin and end -- */
   if (!kpds_set_attribute(o, KPDS_LOCATION_BEGIN, 
			   -1.0, -2.0, -2.0, 0.0, 0.0))
      FAIL("can't set begin");
   if (!kpds_set_attribute(o, KPDS_LOCATION_END, 
			   -5.0, -5.0, -5.0, 10.0, 10.0))
      FAIL("can't set end");

   /* -- make sure the position attribute works -- */
   if (!kpds_set_attribute(o, KPDS_LOCATION_POSITION, 0, 0, 0, 0))
      FAIL("can't set position");

   /* -- get the location data in curvilinear form -- */
   data = kpds_get_data(o, KPDS_LOCATION_ALL, data);
   kprintf("Testing all get :\n"); 
   for (w = 0; w < 3; w++)
      for (h = 0; h < 4; h++)
         for (d = 0; d < 4; d++)
	 {
	    kprintf(" %d %d %d  :", w, h, d);
            for (i = 0; i < 3; i++)
	       kprintf(" %g ", data[w+3*(h+4*(d+4*i))]);
	    kprintf("\n");
	 }
   kfree(data);

   if (!kpds_set_attribute(o, KPDS_LOCATION_POSITION, 2, 1, 2, 1))
      FAIL("can't set position");

   /* -- get the location data in curvilinear form -- */
   data = kpds_get_data(o, KPDS_LOCATION_POINT, NULL);
   kprintf("\nTesting point get :\n 2 1 2 1 : %g\n", data[0]);
   kfree(data);

   /* -- try uniform padding out -- */
   if (!kpds_set_attribute(o, KPDS_LOCATION_POSITION, -1, -1, -1, 0))
      FAIL("can't set position");

   data = kpds_get_data(o, KPDS_LOCATION_POINT, NULL);
   kprintf("\nTesting padding get :\n -1 -1 -1 0 : %g\n", data[0]);
   kfree(data);


   if (!kpds_set_attribute(o, KPDS_LOCATION_POSITION, -1, 0, 0, 0))
      FAIL("can't set position");

   if (!kpds_set_attribute(o, KPDS_LOCATION_REGION_SIZE, 3, 1, 1, 1))
      FAIL("can't set region size");
   data = kpds_get_data(o, KPDS_LOCATION_REGION, NULL);
   kprintf("\nTesting padded region get :\n -1 0 0 0 : %g\n", data[0]);
   kprintf("  0 0 0 0 : %g\n", data[1]);
   kprintf("  1 0 0 0 : %g\n", data[2]);
   kfree(data);

   kpds_close_object(o);



   o = kpds_open_output_object("rtest.xv");

   kprintf("\n\n////RECTILINEAR TEST\n"); 
   /* -- create some rectilinear location -- */
   kpds_set_attribute(o, KPDS_LOCATION_GRID, KRECTILINEAR);
   kpds_create_location(o);

   kpds_set_attributes(o, KPDS_LOCATION_DATA_TYPE, KFLOAT,
	 		  KPDS_LOCATION_SIZE, 3, 4, 2, 1,
		          NULL);

   /* -- put the rectilinear data -- */
   if (!kpds_put_data(o, KPDS_LOCATION_WIDTH_ALL, width))
      FAIL("can't put width");
   if (!kpds_put_data(o, KPDS_LOCATION_HEIGHT_ALL, height))
      FAIL("can't put height");
   if (!kpds_put_data(o, KPDS_LOCATION_DEPTH_ALL, depth))
      FAIL("can't put depth");

   /* -- make sure the position attribute works -- */
   if (!kpds_set_attribute(o, KPDS_LOCATION_POSITION, 0, 0, 0, 0))
      FAIL("can't set position");

   kpds_set_attribute(o, KPDS_LOCATION_DATA_TYPE, KDOUBLE);

   /* -- get the location data in curvilinear form -- */
   data = kpds_get_data(o, KPDS_LOCATION_ALL, NULL);
   kprintf("Testing all get :\n"); 
   for (w = 0; w < 3; w++)
      for (h = 0; h < 4; h++)
         for (d = 0; d < 2; d++)
	 {
	    kprintf(" %d %d %d  :", w, h, d);
            for (i = 0; i < 3; i++)
	       kprintf(" %g ", data[w+3*(h+4*(d+2*i))]);
	    kprintf("\n");
	 }
   kfree(data);

   if (!kpds_set_attribute(o, KPDS_LOCATION_POSITION, 1, 3, 0, 1))
      FAIL("can't set position");
   
   /* -- get the location data in curvilinear form -- */
   data = kpds_get_data(o, KPDS_LOCATION_POINT, NULL);
   kprintf("\nTesting point get :\n 1 3 0 1 : %g\n", data[0]);
   kfree(data);

   kpds_close_object(o);

   return(0);
}
