 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Segment Definitions
   >>>>
   >>>>    Written By: Steve Kubica
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdms_segue_h_
#define _kdms_segue_h_

 /*-------------------------------------*
 |       #include
 ---------------------------------------*/

 /*-------------------------------------*
 |       #defines
 ---------------------------------------*/

 /*-------------------------------------*
 |       typedefs
 ---------------------------------------*/

/*   Data Services Segment Definition
 *  .........................................................................
 */
typedef struct _kdms_segment_defin {

   char *segment;   /* segment name */

   int lock;        /* lock down the definition if it is in use */

   int (*create)    PROTO((kobject, char *));
   int (*destroy)   PROTO((kobject, char *));
   int (*query)     PROTO((kobject, char *));

   kaddr (*get_data) PROTO((kobject, char *, int *, int *, kaddr));
   int   (*put_data) PROTO((kobject, char *, int *, int *, kaddr));

   int (*get_atr)   PROTO((kobject, char *, char *, kva_list *));
   int (*set_atr)   PROTO((kobject, char *, char *, kva_list *));
   int (*match_atr) PROTO((kobject, kobject, char *, char *));
   int (*copy_atr)  PROTO((kobject, kobject, char *, char *));
   int (*query_atr) PROTO((kobject, char *, char *,int *,int *,int *,int *));
   int (*print_atr) PROTO((kobject, char *, char *, kfile *));
   
} kdms_segment_defin;

 /*-------------------------------------*
 |       global variable declarations
 ---------------------------------------*/

 /*-------------------------------------*
 |       macros
 ---------------------------------------*/

 /*-------------------------------------*
 |       routine definitions
 ---------------------------------------*/

kdms_segment_defin *kdms_locate_segment_defin PROTO((char *));

#endif	/* _kdms_segue_h_ */

/* Don't add after this point */
