 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Attribute Definitions
   >>>>
   >>>>    Written By: Steve Kubica and Jeremy Worley
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdms_attributes_h_
#define _kdms_attributes_h_

 /*-------------------------------------*
 |       #include
 ---------------------------------------*/

 /*-------------------------------------*
 |       #defines
 ---------------------------------------*/

#define KDMS_QUASI_ATTRIBUTE_TYPE   1
#define KDMS_GENERIC_ATTRIBUTE_TYPE 2

 /*-------------------------------------*
 |       typedefs
 ---------------------------------------*/

/*   Data Services Attribute Base Class 
 *  .........................................................................
 */
typedef struct _kdms_base_attribute {
   
   int type;		/* Type of attribute */
   int attribute; 	/* Attribute Token */

} kdms_base_attribute;

/*
 *   Data Services Generic "Brand X" Attribute Class
 *  .........................................................................
 */
typedef struct _kdms_generic_attribute {

   int type;		/* Type of attribute */
   int attribute; 	/* Attribute Token */

   int data_type;	/* Data type of generic attribute */
   int arg_size;	/* Size of each attribute argument */
   int num_args;	/* Number of attribute arguments */
   
   int permanent;	/* Persistence of the attribute */

   kaddr value;         /* Actual Storage (TM) of attribute values */

} kdms_generic_attribute;

/*
 *   Data Services Quasi Attribute Class
 *  .........................................................................
 */
typedef struct _kdms_quasi_attribute {

   int type;		/* Type of attribute */
   int attribute; 	/* Attribute Token */

   int (*get)   PROTO((kobject, int, int, kaddr, kva_list *));
   int (*set)   PROTO((kobject, int, int, kaddr, kva_list *));
   int (*match) PROTO((kobject, kobject, int, int, kaddr, kaddr));
   int (*copy)  PROTO((kobject, kobject, int, int, kaddr, kaddr));
   int (*query) PROTO((kobject, int, int, kaddr, int *,int *,int *,int *));
   int (*print) PROTO((kobject, int, int, kaddr, kfile *));

   kaddr clientData;   /* Attribute specific client data */

} kdms_quasi_attribute;

/*
 *   Data Services Attribute Class
 *  .........................................................................
 */
typedef union _kdms_attribute {

   kdms_base_attribute     base;
   kdms_generic_attribute  generic;
   kdms_quasi_attribute    quasi;

} kdms_attribute;


/*
 *   Data Services Attribute List
 *  .........................................................................
 */
typedef struct _kdms_attribute_list {

   int              nattributes;
   kdms_attribute **attributes;

} kdms_attribute_list;


/*
 *   Data Services Attribute Definition
 *  .........................................................................
 */
typedef struct _kdms_attribute_defin {

   char *attribute; 
   char *association; 

   kdms_attribute *atr;
   int		   shared;	/* Presentation or Physical */

} kdms_attribute_defin;


 /*-------------------------------------*
 |       global variable declarations
 ---------------------------------------*/

 /*-------------------------------------*
 |       macros
 ---------------------------------------*/

 /*-------------------------------------*
 |       routine definitions
 ---------------------------------------*/

#endif	/* _kdms_attributes_h_ */

/* Don't add after this point */
