 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Application Services Internals
   >>>>
   >>>>    Written By: Jeremy Worley and Steve Kubica
   >>>>
   >>>>          Date: Oct 07, 1993 13:41
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _internals_h_
#define _internals_h_


	/*-------------------------------------*
	|       #include 
	---------------------------------------*/

#include <dataserv.h>


	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

#define KPDS_SEGMENT_VALUE 	KDMS_SEGMENT_VALUE
#define KPDS_SEGMENT_MASK 	KDMS_SEGMENT_MASK
#define KPDS_SEGMENT_LOCATION 	KDMS_SEGMENT_LOCATION
#define KPDS_SEGMENT_TIME 	KDMS_SEGMENT_TIME 
#define KPDS_SEGMENT_MAP 	KDMS_SEGMENT_MAP

#define KPDS_SEGMENT_WIDTH 	"width"
#define KPDS_SEGMENT_HEIGHT 	"height"
#define KPDS_SEGMENT_DEPTH 	"depth"
#define KPDS_SEGMENT_UNIFORM	"uniform"

#define _INTERNAL_INC_STATE 	      "internalIncrementStateMachine"
#define _INTERNAL_POSITION  	      "internalPosition"
#define _INTERNAL_OFFSET    	      "internalOffset"
#define _INTERNAL_INCREMENT_SIZE      "internalIncrementSize"

#define _STORED_LOCATION_GRID 	      "locationGrid"

#define _INTERNAL_MAP_AUTOCOLOR         "mapAutocolor"
#define _INTERNAL_MAP_OPERATION 	"mapAutocolorOperation"
#define _INTERNAL_COLORSPACE          	"colorspace"
#define _INTERNAL_HISTORY       	"history"

#define _INTERNAL_REGION_CONSTRAINT     "internalRegionConstraint"
#define _INTERNAL_REGION_FLAGS 		"internalRegionFlags"

/* -- uniform and rectilinear location data attributes -- */
#define KPDS_UNIFORM_PRES_LOCATION_SIZE "uniformPresSize"
#define KPDS_UNIFORM_PHYS_LOCATION_SIZE "uniformSize"
#define KPDS_RECTILINEAR_PRES_DIMENSION "rectilinearPresDimension"
#define KPDS_RECTILINEAR_PHYS_DIMENSION "rectilinearDimension"

/* -- polymorphic segment dimensions -- */
#define KPDS_VALUE_DIM     5
#define KPDS_MASK_DIM      5
#define KPDS_LOCATION_DIM  4
#define KPDS_TIME_DIM      1
#define KPDS_MAP_DIM       5

/* -- predefined indices into size, position, and offset arrays -- */
#define KWID  0
#define KHGT  1
#define KDEP  2
#define KTIM  3
#define KELM  4

#define KDIM  3

#define KMAP_WID  0
#define KMAP_HGT  1
#define KMAP_DEP  2
#define KMAP_TIM  3
#define KMAP_ELM  4

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _kaps_primitive {
    char *name;
    int   token;
    int   seg_token;
    char *segment;
    int   usage[KDMS_MAX_DIM];
    kaddr (*get)  PROTO((kobject,struct _kaps_primitive *,kaddr));
    int   (*put)  PROTO((kobject,struct _kaps_primitive *,kaddr));
} kaps_primitive;

	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/


	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

/* map_autocolor.c */
void kmap_map_autocolor(kobject, int);
void kmap_map_operation(kobject, int);

/* autoinc.c */
int kaps_increment_position       PROTO((int *, int *, int *, int));
int kdut_advance_position         PROTO((int *, int *, int *, int *, int, int));
int kaps_advance_segment_position PROTO((kobject,char *,int *,int *, int *,
					 int));

/* model_attrib.c */
void kaps_init PROTO((void));

/* model_data.c */
void kaps_offset_corners  PROTO((kobject, char *, int *, int *, int *));
kaddr kaps_get_primitive         PROTO((kobject, kaps_primitive *, kaddr));
int kaps_put_primitive           PROTO((kobject, kaps_primitive *, kaddr));
int kaps_copy_segment_data       PROTO((kobject, char *, kobject));
int kaps_copy_object             PROTO((kobject, kobject, int, int));
int kaps_copy_remaining_segments PROTO((kobject, kobject, int, int));
int kaps_copy_global_attributes  PROTO((kobject, kobject));
int kaps_initialize_segment      PROTO((kobject, char *, double, double));


/* model_utils.c */
int  kaps_get_segment_dimension PROTO((kobject, char *));
int *kaps_get_segment_size      PROTO((kobject, char *));
int *kaps_get_segment_position  PROTO((kobject, char *));
int  kaps_set_segment_position  PROTO((kobject, char *, int *));
int *kaps_get_segment_offset    PROTO((kobject, char *));
int  kaps_set_segment_offset    PROTO((kobject, char *, int *));
int  kaps_get_segment_inc_state PROTO((kobject, char *, int *, int *, int *));
int  kaps_set_segment_inc_state PROTO((kobject, char *, int, int, int));
int  kaps_set_attributes        PROTO((kobject, char *, kvalist));
int  kaps_get_attributes        PROTO((kobject, char *, kvalist));

int kaps_call_get_handler PROTO((
                  int (*) PROTO ((kobject ,int ,int ,kaddr ,kva_list *)), 
		                  kobject, int, int, kaddr, kvalist));
int kaps_call_set_handler PROTO((
                  int (*) PROTO ((kobject ,int ,int ,kaddr ,kva_list *)), 
		                  kobject, int, int, kaddr, kvalist));
void kaps_current_date PROTO((char *));
int  kaps_legal_data_type PROTO((int));


/* mapping.c */
int kaps_map_data PROTO((int *, int *, int *, kaddr, int *, int, int, 
			 kaddr, double, double));
kaddr kaps_get_mapped_value_data PROTO((kobject, int *, int *, kaddr));
kaddr kaps_get_mapped_mask_data  PROTO((kobject, int *, int *, kaddr));
kaddr kaps_mask_data             PROTO((kobject, int *, int *, kaddr));
kaddr kaps_get_uniform_data      PROTO((kobject, int *, int *, kaddr));
kaddr kaps_get_rectilinear_data  PROTO((kobject, int *, int *, kaddr));

kaddr kaps_transpose_elements_first PROTO((kaddr, int *, int *, int, int));
kaddr kaps_transpose_elements_last PROTO((kaddr, int *, int *, int, int));

int kaps_mapping_mode        PROTO((kobject));
int kaps_masked_presentation PROTO((kobject));
int kaps_location_grid       PROTO((kobject));
int kaps_elements_first      PROTO((kobject));

int   kaps_copy_data PROTO ((kobject, char *, kobject, char *));

/* pds_value.c */
int kpds_init_value_segment PROTO((void));

/* pds_mask.c */
int kpds_init_mask_segment PROTO((void));

/* pds_map.c */
int kpds_init_map_segment PROTO((void));

/* pds_location.c */
int kpds_init_location_segment PROTO((void));

/* pds_time.c */
int kpds_init_time_segment PROTO((void));

#endif /* _internals_h_ */
/* Don't add after this point */


