 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: The "xbm" format describes the conversion
   >>>>		       used for the format:
   >>>>
   >>>>			   X11 Bitmap Format
   >>>>
   >>>>	               The format was orignially developed by the
   >>>>		       company/persons:
   >>>>
   >>>>			   MIT Project Athena
   >>>>
   >>>>    Written By: Mark Young
   >>>>
   >>>>          Date: Oct 07, 1993 13:41
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kdatafmt_xbm_h_
#define _kdatafmt_xbm_h_

/*
 *	The "xbm" image file format describes the format used by
 *	the X11 Bitmap Format  conversion routines.  The format was developed
 *	by MIT Project Athena
 *
 *	The following structure is used by the conversion routines to read
 *	and write the xbm files.  This format is not a standard, just an
 *	intermediate format used by the Khoros routines to do convert xbm
 *	files to and from the format.
 */

	/*-------------------------------------*
	|       #defines 
	---------------------------------------*/

	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/

typedef struct _xbm {
	int  width;
	int  height;
	char *data;
} xbm;

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

xbm	*xbm_readheader PROTO((int));
xbm	*xbm_read	PROTO((char *));
xbm	*xbm_fdread	PROTO((int));
xbm	*xbm_create     PROTO((void));
int	xbm_writeheader PROTO((int, xbm *));
int	xbm_write	PROTO((char *, xbm *));
int	xbm_fdwrite	PROTO((int, xbm *));
int	xbm_free	PROTO((xbm *));


#endif /* _kdatafmt_xbm_h_ */
/* Don't add after this point */
