/*
 * Khoros: $Id$
 */
 
/*
 * $Log$
 */
 
/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */


/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>>
   >>>>       Purpose: Definitions and prototypes for library kapputils
   >>>>
   >>>>       Toolbox: $DATASERV
   >>>>
   >>>>    Written By: Your name goes here!
   >>>>
   >>>>          Date: 
   >>>>
   >>>> Modifications:
   >>>>
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */

#ifndef _kapputils_h_
#define _kapputils_h_


	/*-------------------------------------*
	|       #include
	---------------------------------------*/

#include <kapputils/append.h>

	/*-------------------------------------*
	|       #defines
	---------------------------------------*/


	/*-------------------------------------*
	|       typedefs
	---------------------------------------*/


	/*-------------------------------------*
	|       global variable declarations
	---------------------------------------*/


	/*-------------------------------------*
	|       macros
	---------------------------------------*/

/* Fix up a wrapper to use for calling routines so that we don't have to
   explicitly check for errors, free object, etc, after each call. */
#define KCALL(func) \
if (!(func)) \
  { \
    if (kstrstr(STRINGARG(func),"_set_attribute") != NULL) \
      kerror(lib,rtn,"Unable to set object attributes"); \
    else if (kstrstr(STRINGARG(func),"_get_attribute") != NULL) \
      kerror(lib,rtn,"Unable to get object attributes"); \
    else if (kstrstr(STRINGARG(func),"_get_data") != NULL) \
      kerror(lib,rtn,"Unable to get data from object"); \
    else if (kstrstr(STRINGARG(func),"_put_data") != NULL) \
      kerror(lib,rtn,"Unable to put data to object"); \
    else if (kstrstr(STRINGARG(func),"_reference_object") != NULL) \
      kerror(lib,rtn,"Unable to reference_object"); \
    else if (kstrstr(STRINGARG(func),"_create_") != NULL) \
      kerror(lib,rtn,"Unable to create segment or attribute"); \
    else if (kstrstr(STRINGARG(func),"_destroy_") != NULL) \
      kerror(lib,rtn,"Unable to destroy segment or attribute"); \
    else if (kstrstr(STRINGARG(func),"_open_") != NULL) \
      kerror(lib,rtn,"Unable to open object"); \
    else if (kstrstr(STRINGARG(func),"_close_") != NULL) \
      kerror(lib,rtn,"Unable to close object"); \
    else if (kstrstr(STRINGARG(func),"_copy_") != NULL) \
      kerror(lib,rtn,"Unable to copy segment, attribute, data, or object"); \
    else \
      kerror(lib,rtn,"Got an error from subroutine call:\n  %s\n",STRINGARG(func)); \
    kinfo(KVERBOSE,"%s:%s: Offending source code:\n  %s\n",lib,rtn,STRINGARG(func)); \
    (void)klist_free(objlist, (kfunc_void)lkcall_free); \
    return(0); \
  }

	/*-------------------------------------*
	|       routine definitions
	---------------------------------------*/

    /* exprn.c */
 
int kapu_append PROTO((kobject *, int, int, int, int, int, int, int, kobject));
int kapu_exprn_function PROTO((char *, kobject *, int, kobject));
int kapu_exprn_generate PROTO((char *, int, int, int, int, int, double, double,
			       double, double, double, double, double, double,
			       double, double, int, kobject));
int kapu_inset PROTO((kobject, kobject, int, int, int, int, int, int, int, int,
		      int, int, double, double, int, int, int, kobject));
 
int kapu_upgrade_objects   PROTO((int *, int *, int *, int *, int *, int *,
                                  int, int, int, int, int, kvalist));
int kapu_mask_ops    PROTO((kobject, int, int, kvalist));
int kapu_multi_input_loc    PROTO((int *, int, kvalist));
int kapu_multi_input_time   PROTO((int, kvalist));

    /* utilities.c */
 
int lkcall_free PROTO((klist *));

	/* Ghostwriter Prototypes:  Do Not Erase This Comment */


#endif /* _kapputils_h_ */
/* Don't add after this point */
