#! /bin/sh 

echo "running test1.sh for knormal ... process ($$)"

echo "         Test  1 normalize for mask, loc, and value"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  normalize (-1 to 1) for mask, loc, and value
# ------------------------------------------------------------------------

# Create value data 
cat <<EOF > $tmpdir/ascii.$$
-2 -1 -3 7
7 58 59 13
36 3 38 1
1 -2 -3 -4
EOF

kasc2val -i1 $tmpdir/ascii.$$ -o $tmpdir/vdata.$$ -type Integer -wsize 4 -hsize 2 -dsize 2 

# Create mask data and insert into object with value data
cat <<EOF > $tmpdir/ascii.$$
1 1 1 1
1 0 0 1
1 0 0 1
1 1 1 1
EOF
kasc2mask -i1 $tmpdir/ascii.$$ -i2 $tmpdir/vdata.$$ -o $tmpdir/vmdata.$$ -type "Unsigned Byte" -wsize 4 -hsize 2 -dsize 2 

# Create location data and insert into object with value and mask data
cat <<EOF > $tmpdir/ascii.$$
0.5 1.5 2.5 3
4.2 4.3 4.4 5
5.0 5.5 6.0 7
8   9.5 10  12
EOF
kasc2loc -i1 $tmpdir/ascii.$$ -i2 $tmpdir/vmdata.$$ -o $tmpdir/vmldata.$$ -type "Float" -wsize 4 -hsize 2 -dsize 2 

# ---------- Test 1a --> normalize (-1 to 1) for mask, loc, and value -whole

test_num=1a
descr="normalize (-1 to 1) for mask, loc, and value -w"
knormal -i $tmpdir/vmldata.$$ -o $tmpdir/out.$$ -uval 1 -lval -1 -whole -type "Float"
cat <<EOF > $tmpdir/ascii2.$$
-0.9365079365 -0.9047619048 -0.9682539683 -0.6507936508
-0.6507936508  0.9682539683  1            -0.4603174603
 0.2698412698 -0.7777777778  0.3333333333 -0.8412698413
-0.8412698413 -0.9365079365 -0.9682539683 -1
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/vmldata.$$ -o $tmpdir/answer.$$ -type "Float" -wsize 4 -hsize 2 -dsize 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 1b --> normalize (-1 to 1) value only, dmin = -10, dmax = 70

test_num=1b
descr="normalize (-1 to 1) value only, dmin = -10, dmax = 70"
knormal -i $tmpdir/vdata.$$ -o $tmpdir/out.$$ -uval 1 -lval -1 -whole -type "Float" -dmin -10 -dmax 70
cat <<EOF > $tmpdir/ascii2.$$
-0.8	-0.775	-0.825	-0.575
-0.575	 0.7	 0.725	-0.425
 0.15	-0.675	 0.2	-0.725
-0.725	-0.8	-0.825	-0.85
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -o $tmpdir/answer.$$ -type "Float" -wsize 4 -hsize 2 -dsize 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ---------- Test 1c --> normalize (-1 to 1) for mask (substitute) and value -w

test_num=1c
descr="normalize (-1 to 1) for mask (substitute = 59) and value -w"
ksetdattr -i $tmpdir/vmdata.$$ -o $tmpdir/vmdata.$$ -maskpres "Substitute Value" -rmasksub 59 -imasksub 0
knormal -i $tmpdir/vmdata.$$ -o $tmpdir/out.$$ -uval 1 -lval -1 -whole -type "Float"
cat <<EOF > $tmpdir/ascii2.$$
-0.9365079365 -0.9047619048 -0.9682539683 -0.6507936508
-0.6507936508  1	     1  	  -0.4603174603
 0.2698412698  1	     1		  -0.8412698413
-0.8412698413 -0.9365079365 -0.9682539683 -1
EOF
kasc2val -i1 $tmpdir/ascii2.$$ -i2 $tmpdir/vmdata.$$ -o $tmpdir/answer.$$ -type "Float" -wsize 4 -hsize 2 -dsize 2
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr"

# ------------------------------------------------------------------------
# end of testing
# ------------------------------------------------------------------------

/bin/rm $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/ascii2.$$ 
/bin/rm $tmpdir/vdata.$$ $tmpdir/answer.$$ 
/bin/rm $tmpdir/vmdata.$$ $tmpdir/vmldata.$$

exit $status

