#! /bin/sh

echo "running test1.sh for kinset ... process ($$)"

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}


kextract -i image:head -o $tmpdir/junk1.$$  -woff 10 -hoff 10 -doff 0 \
	 -toff 0 -eoff 0 -wsize 246 -hsize 218 -tsize 1 -dsize 1 -esize 1 \
	 -subpos FALSE

kconvert -i $tmpdir/junk1.$$ -o $tmpdir/junk2.$$ -val -type "Double Complex"

kconvert -i image:head -o $tmpdir/junk3.$$ -val -type "Double Complex"

kinset -i1 $tmpdir/junk3.$$ -i2 $tmpdir/junk2.$$ -o $tmpdir/junk4.$$ \
	-woff 10 -hoff 10 -doff 0 -toff 0 -eoff 0 

karith2 -i1 $tmpdir/junk4.$$ -i2 $tmpdir/junk3.$$ -o $tmpdir/cdiff.$$ -sub
kconvert -i $tmpdir/cdiff.$$ -o $tmpdir/fdiff.$$ -val -type Float

# echo  " "
# echo  " Done extracting and inserting data "
# echo  " Done creating two output objects for comparison "
# echo  " "

kstats -all -i $tmpdir/fdiff.$$ -o $tmpdir/stats.$$

ksegcmp -i1 $tmpdir/stats.$$ -i2 test1.results/stats -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Statistics check on inserting value data passed."
else
   echo "FAILED:  Statistics check on inserting value data failed."
   status=1
fi

/bin/rm -f $tmpdir/junk*.$$ $tmpdir/*diff.$$ $tmpdir/stats.$$

exit $status


# to run this sequence from the commmand line
# kextract -i image:head -o junk1 -woff 10 -hoff 10 -doff 0 -toff 0 -eoff 0 -wsize 246 -hsize 218 -tsize 1 -dsize 1 -esize 1 -subpos FALSE
# kconvert -i junk1 -o junk2 -val -type "Double Complex"
# kconvert -i image:head -o junk3 -val -type "Double Complex"
# kinset -i1 junk3 -i2 junk2 -o junk4 -woff 10 -hoff 10 -doff 0 -toff 0 -eoff 0
# karith2 -i1 junk4 -i2 junk3 -o cdiff -sub
# kconvert -i cdiff  -o fdiff -val -type Float
# kstats -all -i fdiff -o stats
# kprdata -i stats -val
# kprdata -i test1.results/stats -val

