#! /bin/sh 

echo "running test1.sh for kgnoise ... process ($$)"

tmpdir=${TMPDIR:-/usr/tmp}
# kgnoise can generate 5 types of noises. Due to the random nature of the 
# operation the results can be predicted only statistically. There are 5 tests
# for kgnoise in this testsuite each testing for a different kind of noise.
# The stats of the output noise are computed. A tolerance of 3/4 % from the
# specified parameters is considered acceptable in this testsuite. Some of
# the noises generated have integer types. In this case the effects on the
# noise distribution cannot be predicted but the noise parameters are expected
# to be close to the specified value. The size of the dataset should be 
# sufficiently large to let the stats converge to the specified value.
 
# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tol="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol $tol -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"

# ---------------------------------------------------------------------------
#  Test 1: Uniform noise of type float	
# --------------------------------------------------------------------------
# total number of points generated = 8*16*8*3*20 = 61440
kgnoise -o $tmpdir/out.$$ -wsize 8 -hsize 16 -dsize 8 -tsize 3 -esize 20 -type "float" -unif -umax 11.0 -umin 10.0
kstats -i $tmpdir/out.$$ -mean -o $tmpdir/mean.$$
kstats -i $tmpdir/out.$$ -var -o $tmpdir/var.$$
 
test_num="1a"
descr="Uniform noise of type float - test mean (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
10.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/mean.$$" "$tmpdir/ans.$$" "$descr" "0.21"
 
test_num="1b"
descr="Uniform noise of float - test variance (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
0.08333
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/var.$$" "$tmpdir/ans.$$" "$descr" "0.0017"
 
/bin/rm -f  $tmpdir/out.$$ $tmpdir/mean.$$ $tmpdir/var.$$
/bin/rm -f  $tmpdir/ascii.$$ $tmpdir/ans.$$

# ---------------------------------------------------------------------------
#  Test 2: Poisson noise of type double
# ---------------------------------------------------------------------------
# total number of points generated = 6*15*11*71 = 70290
kgnoise -wsize 6 -hsize 1 -dsize 15 -tsize 11 -esize 71 -type "double" -o $tmpdir/out.$$ -poiss -pvar 200.0 -ptime 4.0 
kstats -i $tmpdir/out.$$ -mean -o $tmpdir/mean.$$
kstats -i $tmpdir/out.$$ -var -o $tmpdir/var.$$
 
cat <<EOF > $tmpdir/ascii.$$
200
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
 
test_num="2a"
descr="Poisson noise of type double - test mean (2% tol)"
report "$test_num" "$tmpdir/mean.$$" "$tmpdir/ans.$$" "$descr" "4"

test_num="2b"
descr="Poisson noise of type double - test variance (2% tol)"
report "$test_num" "$tmpdir/var.$$" "$tmpdir/ans.$$" "$descr" "4"
 
/bin/rm -f  $tmpdir/out.$$ $tmpdir/mean.$$ $tmpdir/var.$$
/bin/rm -f  $tmpdir/ascii.$$ $tmpdir/ans.$$

# ---------------------------------------------------------------------------
#  Test 3: Rayleigh noise of type float
# ---------------------------------------------------------------------------
# total number of points generated = 10*23*41*7 = 66010
kgnoise  -o $tmpdir/out.$$ -wsize 12 -hsize 23 -dsize 41 -tsize 7 -esize 1 -type "float" -ray -rvar 51.0
kstats -i $tmpdir/out.$$ -mean -o $tmpdir/mean.$$
kstats -i $tmpdir/out.$$ -var -o $tmpdir/var.$$
 
test_num="3a"
descr="Rayleigh noise of type float - test mean (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
13.66
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/mean.$$" "$tmpdir/ans.$$" "$descr" "0.27"
 
test_num="3b"
descr="Rayleigh noise of type float - test variance (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
51
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/var.$$" "$tmpdir/ans.$$" "$descr" "1.02"
 
/bin/rm -f  $tmpdir/out.$$ $tmpdir/mean.$$ $tmpdir/var.$$
/bin/rm -f  $tmpdir/ascii.$$ $tmpdir/ans.$$

# ---------------------------------------------------------------------------
#  Test 4: Gaussian noise of type float
# ---------------------------------------------------------------------------
# total number of points generated = 2*42*47*17 = 67116
kgnoise -o $tmpdir/out.$$ -type "float" -wsize 2 -hsize 42 -dsize 1 -tsize 47 -esize 17 -gauss -gmean 4500.0 -gvar 3000
kstats -i $tmpdir/out.$$ -mean -o $tmpdir/mean.$$
kstats -i $tmpdir/out.$$ -var -o $tmpdir/var.$$
 
test_num="4a"
descr="Gaussian noise of type float - test mean (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
4500
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/mean.$$" "$tmpdir/ans.$$" "$descr" "90"
 
test_num="4b"
descr="Gaussian noise of type float - test variance (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
3000
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/var.$$" "$tmpdir/ans.$$" "$descr" "60"
 
/bin/rm -f  $tmpdir/out.$$ $tmpdir/mean.$$ $tmpdir/var.$$
/bin/rm -f  $tmpdir/ascii.$$ $tmpdir/ans.$$

# ---------------------------------------------------------------------------
#  Test 5: Exponential noise of type double
# ---------------------------------------------------------------------------
# total number of points generated = 24*24*40*3 = 69120
kgnoise -o $tmpdir/out.$$ -type "double" -wsize 1 -hsize 24 -dsize 24 -tsize 40 -esize 3 -exp -evar 400.0
kstats -i $tmpdir/out.$$ -mean -o $tmpdir/mean.$$
kstats -i $tmpdir/out.$$ -var -o $tmpdir/var.$$
 
test_num="5a"
descr="Exponential noise of type double - test mean (2% tol)"
cat <<EOF > $tmpdir/ascii.$$
20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/mean.$$" "$tmpdir/ans.$$" "$descr" "0.4"
# echo "------- mean should be 20 +- 0.4 (2%)--------"
# kprdata -i "$tmpdir/mean.$$" -val
 
test_num="5b"
descr="Exponential noise of type double - test variance (3% tol)"
cat <<EOF > $tmpdir/ascii.$$
400
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type double -o $tmpdir/ans.$$
report "$test_num" "$tmpdir/var.$$" "$tmpdir/ans.$$" "$descr" "12"
# echo "------- variance should be 400 +- 12 (3%) --------"
# kprdata -i "$tmpdir/var.$$" -val
 
/bin/rm -f  $tmpdir/out.$$ $tmpdir/mean.$$ $tmpdir/var.$$
/bin/rm -f  $tmpdir/ascii.$$ $tmpdir/ans.$$
exit $status
