#! /bin/sh

# Replace oname and file.sh in the two lines below with the name 
# of the program you are testing and the file name of this test 
# (for example, test1.sh).

object_name="kgenloc"
file_name="test1.sh"

# ---------------------------------------------------------------
# ADD TESTS BETWEEN the  "Add tests below this" and "End of test 
# suite" comment lines (line 60).
# ---------------------------------------------------------------

echo "running "$file_name" for "$object_name" ... process ($$)"

# report utility
# ---------------------------------------------------------------
# Usage:  report  test_num test_obj cntrl_obj test_descr tol
#
# The report function uses ksegcmp to compare the test output 
# data object ($2) against the correct result ($3), and reports 
# success or failure of the test.  If the result of ksegcmp is 
# false, status is set to 1.
#
# Input Arguments: test_num - test number
#                  test_obj - the object generated by the test
#                  cntrl_obj - known result to compare against
#                  test_descr - a string describing the test
#                  tol - tolerance allowed when comparing object 
#                        data values. Recommended tolerance 1e-5
# ---------------------------------------------------------------
report()
{
   test_num="$1"
   test_obj="$2"
   cntrl_obj="$3"
   test_descr="$4"
   tol="$5"

   ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tol" -sat 1 -s -rt 1 -all
   if [ $? = 0 ]
   then
      echo "Passed:  Test  $test_num --> "$test_descr""
   else
      echo "FAILED:  Test  $test_num --> "$test_descr""
      status=1
   fi
}

# Initialize status to be success (ie. 0).  Upon failure, status 
# is initialized to 1.  Set the tmpdir variable.  Script will 
# use /tmp if $TMPDIR is not defined.
status=0
tmpdir=${TMPDIR:-/tmp}

# ---------------------------------------------------------------
#  Add tests below this
# ---------------------------------------------------------------


# Build data2 - 3w 2t int
#cat <<EOF > $tmpdir/ascii.$$
#20 21 22
#23 24 25
#EOF
#kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -tsize 2 -type int -o $tmpdir/data2.$$

# Build data3 - 3h 2e float value
#cat <<EOF > $tmpdir/ascii.$$
#30 31 32
#33 34 35
#EOF
#kasc2val -i1 $tmpdir/ascii.$$ -hsize 3 -esize 2 -type byte -o $tmpdir/data3.$$

# Build data4 - 3w 2h byte value 
#cat <<EOF > $tmpdir/ascii.$$
#40 41 42
#43 44 45
#EOF
#kasc2val -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 2 -type byte -o $tmpdir/data4.$$

# Build prepend answer for -i1 data1 -i2 data2 -i3 data3 -i4 data4
#cat <<EOF > $tmpdir/ascii.$$
#20 21 22   30   40 41 42   100  101  102
#0  0  0    31   43 44 45   110  111  112
#0  0  0    32    0  0  0     0    0    0

#23 24 25   0     0  0  0     0    0    0
#0  0  0    0     0  0  0     0    0    0
#0  0  0    0     0  0  0     0    0    0

#0  0  0    33    0  0  0   200  201  202
#0  0  0    34    0  0  0   210  211  212
#0  0  0    35    0  0  0     0    0    0

#0  0  0     0    0  0  0     0    0    0
#0  0  0     0    0  0  0     0    0    0
#0  0  0     0    0  0  0     0    0    0
#EOF
#kasc2val -i1 $tmpdir/ascii.$$ -wsize 10 -hsize 3 -tsize 2 -esize 2 \
#	 -type int -o $tmpdir/answer.$$

# ---------------------------------------------------------------
# data1 - 3w 2h 2e unsigned byte value 
# data2 - 3w 2t int
# data3 - 3h 2e float value
# data4 - 3w 2h byte value 
# ---------------------------------------------------------------

#-----------------------------------------------
echo "Uniform Tests:"

test_num=1
descr="generate uniform location data on the ball image"

ksetdattr -i image:ball -o $tmpdir/answer.$$ -wend 35 -hend 22 -dend 0 
kgenloc -i image:ball -o $tmpdir/out.$$ -xend 35 -yend 22 -zend 0 -grid 1 \
   -type 11
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$


test_num=2
descr="generate uniform data on ball but ignore size parameters"

ksetdattr -i image:ball -o $tmpdir/answer.$$ -wend 35 -hend 22 -dend 0 
kgenloc -i image:ball -o $tmpdir/out.$$ -xend 35 -yend 22 -zend 0 -grid 1 \
   -type 11 -wsize 10 -hsize 10 -dsize 10
report $test_num "$tmpdir/out.$$" "$tmpdir/answer.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/answer.$$

test_num=3
descr="generate uniform data"

kgenloc  -o $tmpdir/out.$$ -xend 35 -yend 22 -zend 0 -grid 1 \
   -type 5 -wsize 2 -hsize 2 -dsize 2
report $test_num "$tmpdir/out.$$" "test1.results/unif.viff" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$

#-----------------------------------------------
echo "Rectilinear Tests:"

test_num=4
descr="generate rectilinear data"

kgenloc  -o $tmpdir/out.$$ -xend 35 -yend 22 -zend 10 -grid 2 \
   -type 2 -wsize 2 -hsize 2 -dsize 2
report $test_num "$tmpdir/out.$$" "test1.results/rect.viff" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$

#-----------------------------------------------
echo "Curvilinear Tests:"

test_num=5
descr="generate curvilinear data"

kgenloc -o $tmpdir/out.$$ -xend 35 -yend 22 -zend 10 -grid 3 \
   -type 2 -wsize 2 -hsize 2 -dsize 2
report $test_num "$tmpdir/out.$$" "test1.results/curv.viff" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$

# Build data1 in x direction - 3w 1h 1d 3n double location
cat <<EOF > $tmpdir/ascii.$$
1.  3.  5.
2.  2.  2.
3.  3.  3.
EOF
kasc2loc -i1 $tmpdir/ascii.$$ -wsize 3 -hsize 1 -nsize 3 \
	 -type "double" -o $tmpdir/data1.$$

# Build data2 in y direction - 1w 3h 1d 3n double location
cat <<EOF > $tmpdir/ascii.$$
1.  1.  1.
2.  4.  6.
3.  3.  3.
EOF
kasc2loc -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 3 -nsize 3 \
	 -type "double" -o $tmpdir/data2.$$

test_num=6
descr="curvilinear data in x direction only"

kgenloc -o $tmpdir/out.$$ -xbegin 1 -xend 5 -ybegin 2 -yend 6 \
	-zbegin 3 -zend 7 -grid 3 -type 11 -wsize 3 -hsize 1 -dsize 1
report $test_num "$tmpdir/out.$$" "$tmpdir/data1.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/data1.$$

test_num=7
descr="curvilinear data in y direction only"

kgenloc -o $tmpdir/out.$$ -xbegin 1 -xend 5 -ybegin 2 -yend 6 \
	-zbegin 3 -zend 7 -grid 3 -type 11 -wsize 1 -hsize 3 -dsize 1
report $test_num "$tmpdir/out.$$" "$tmpdir/data2.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/ascii.$$ $tmpdir/data2.$$

# ---------------------------------------------------------------
#  End of test suite
# ---------------------------------------------------------------

exit $status
