#! /bin/sh

echo "running test1.sh for kfft ... process ($$)"

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

kextract -i image:moon -o $tmpdir/ref.$$  -woff 200 -hoff 200 -doff 0 \
	 -toff 0 -eoff 0 -wsize 64 -hsize 64 -tsize 1 -dsize 1 -esize 1 \
	 -subpos FALSE
kfft -i $tmpdir/ref.$$ -o $tmpdir/junk1.$$ -w -h -scale 1 -type complex -dir 0 -center 0
kfft -i $tmpdir/junk1.$$ -o $tmpdir/junk2.$$ -w -h -scale 2 -type complex -dir 1 -center 0
karith2 -i1 $tmpdir/junk2.$$ -i2 $tmpdir/ref.$$ -o $tmpdir/junk1.$$ -sub
kconvert -i $tmpdir/junk1.$$ -o $tmpdir/diff.$$ -val -type 8
kstats -i $tmpdir/diff.$$ -o $tmpdir/stats.$$ -all
ksegcmp -i1 $tmpdir/stats.$$ -i2 test1.results/stats1 -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test 1 - (input-ifft(fft(moon)))->long(mag)->stats = zero (64x64)"
else
   echo "FAILED:  Test 1 - (input-ifft(fft(moon)))->long(mag)->stats = zero (64x64)"
   status=1
fi


#   BEGIN SECOND TEST

kfft -i $tmpdir/ref.$$   -o $tmpdir/junk1.$$ -w -h -scale 1 -type "double complex" -dir 0 -center 1
kfft -i $tmpdir/junk1.$$ -o $tmpdir/junk2.$$ -w -h -scale 2 -type 13 -dir 1 -center 1
karith2 -i1 $tmpdir/junk2.$$ -i2 $tmpdir/ref.$$ -o $tmpdir/junk1.$$ -sub
kconvert -i $tmpdir/junk1.$$ -o $tmpdir/diff.$$ -val -type 8
kstats -i $tmpdir/diff.$$ -o $tmpdir/stats.$$ -all
ksegcmp -i1 $tmpdir/stats.$$ -i2 test1.results/stats2 -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test 2 - test for scaling and centering (64x64)"
else
   echo "FAILED:  Test 2 - test for scaling and centering (64x64)"
   status=1
fi

/bin/rm -f  $tmpdir/ref.$$ $tmpdir/junk1.$$ $tmpdir/junk2.$$ $tmpdir/diff.$$ $tmpdir/stats.$$

#	BEGIN THIRD TEST

kimpulse -o $tmpdir/imp.$$ -wsize 4 -wnum 1 -hsize 4 -hnum 1 -dsize 4 -dnum 1 -tsize 4 -tnum 1 -esize 4 -enum 1 -woff 0 -hoff 0 -doff 0 -toff 0 -eoff 0 -fgreal 1 -type 10
kfft -i $tmpdir/imp.$$ -o $tmpdir/junk1.$$ -w -d -h -t -e -center 1 -scale 1 -dir 0
kcmplx2real -i $tmpdir/junk1.$$ -or $tmpdir/junk2.$$
kstats -i $tmpdir/junk2.$$ -o $tmpdir/stats.$$ -sum
cat << EOF > $tmpdir/junk.asc.$$
1024
EOF
kasc2val -i1 $tmpdir/junk.asc.$$ -o $tmpdir/junk.val.$$ -type 11 -wsize 1 -hsize 1
ksegcmp -i1 $tmpdir/stats.$$ -i2 $tmpdir/junk.val.$$ -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test 3 - test for 5D impulse (4x4x4x4x4)"
else
   echo "FAILED:  Test 3 - test for 5D impulse (4x4x4x4x4)"
   status=1
fi

/bin/rm -f  $tmpdir/junk1.$$ $tmpdir/junk2.$$ $tmpdir/junk.asc.$$ $tmpdir/junk.val.$$ $tmpdir/stats.$$ $tmpdir/imp.$$

#       BEGIN FOURTH TEST

kgsin -o $tmpdir/vol.$$ -sin1 -ampl 1 -wsize 32 -hsize 32 -dsize 32 -wnum 2 -hnum 3 \
-dnum 4 -type 11
kfft -i $tmpdir/vol.$$ -o $tmpdir/junk1.$$ -w -d -h -center 0 -scale 1 -dir 0
kcmplx2real -i $tmpdir/junk1.$$ -om $tmpdir/junk2.$$ -mag 
kstats -i $tmpdir/junk2.$$ -o $tmpdir/stats.$$ -maxval -wmax -hmax -dmax
cat << EOF > $tmpdir/junk.asc.$$
16384
2 3 4
EOF
kasc2val -i1 $tmpdir/junk.asc.$$ -o $tmpdir/junk.val.$$ -type 11 -wsize 1 -esize 4
ksegcmp -i1 $tmpdir/stats.$$ -i2 $tmpdir/junk.val.$$ -tol 1e-5 -sat 1 -s -rt 1 \
-all
if [ $? = 0 ]
then
   echo "Passed:  Test 4 - test for 3D sinusoid (32x32x32)"
else
   echo "FAILED:  Test 4 - test for 3D sinusoid (32x32x32)"
   status=1
fi

/bin/rm -f  $tmpdir/junk1.$$ $tmpdir/junk2.$$ $tmpdir/junk.asc.$$ $tmpdir/junk.val.$$ $tmpdir/stats.$$ $tmpdir/vol.$$

#       BEGIN FIFTH TEST
#	Added on behalf of Roberto Lotufo SRW 28-Jul-94

kgsin -o $tmpdir/vol.$$ -sin1 -ampl 1 -wsize 16 -hsize 1024 -wnum 2 -hnum 3 -type 11
kfft -i $tmpdir/vol.$$ -o $tmpdir/junk1.$$ -w -h -center 0 -scale 3 -dir 0
kfft -i $tmpdir/junk1.$$ -o $tmpdir/junk2.$$ -w -h -center 0 -scale 3 -dir 1
kcmplx2real -i $tmpdir/junk2.$$ -or $tmpdir/junk2.$$ 
karith2 -i1 $tmpdir/junk2.$$ -i2 $tmpdir/vol.$$ -o $tmpdir/junk2.$$ -sub
kstats -i $tmpdir/junk2.$$ -o $tmpdir/stats.$$ -maxval
cat << EOF > $tmpdir/junk.asc.$$
0
EOF
kasc2val -i1 $tmpdir/junk.asc.$$ -o $tmpdir/junk.val.$$ -type 11 -wsize 1 -hsize 1 
ksegcmp -i1 $tmpdir/stats.$$ -i2 $tmpdir/junk.val.$$ -tol 1e-5 -sat 1 -s -rt 1 \
-all
if [ $? = 0 ]
then
   echo "Passed:  Test 5 - test for sqrt scaling (16x1024)"
else
   echo "FAILED:  Test 5 - test for sqrt scaling (16x1024)"
   status=1
fi

/bin/rm -f  $tmpdir/junk1.$$ $tmpdir/junk2.$$ $tmpdir/junk.asc.$$ \
$tmpdir/junk.val.$$ $tmpdir/stats.$$ $tmpdir/vol.$$

#       BEGIN SIXTH TEST

kgconst -o $tmpdir/vol.$$ -wsize 32768 -hsize 1 -type 11 -real 1
kfft -i $tmpdir/vol.$$ -o $tmpdir/junk1.$$ -w -center 0 -scale 3 -dir 0
kfft -i $tmpdir/junk1.$$ -o $tmpdir/junk2.$$ -w -center 0 -scale 3 -dir 1
kcmplx2real -i $tmpdir/junk2.$$ -or $tmpdir/junk2.$$ 
karith2 -i1 $tmpdir/junk2.$$ -i2 $tmpdir/vol.$$ -o $tmpdir/junk2.$$ -sub
kstats -i $tmpdir/junk2.$$ -o $tmpdir/stats.$$ -maxval
cat << EOF > $tmpdir/junk.asc.$$
0
EOF
kasc2val -i1 $tmpdir/junk.asc.$$ -o $tmpdir/junk.val.$$ -type 11 -wsize 1 -hsize 1
ksegcmp -i1 $tmpdir/stats.$$ -i2 $tmpdir/junk.val.$$ -tol 1e-5 -sat 1 -s -rt 1 \
-all
if [ $? = 0 ]
then
   echo "Passed:  Test 6 - test for 1D max length vector (1x32768)"
else
   echo "FAILED:  Test 6 - test for 1D max length vector (1x32768)"
   status=1
fi

/bin/rm -f  $tmpdir/junk1.$$ $tmpdir/junk2.$$ $tmpdir/junk.asc.$$ \
$tmpdir/junk.val.$$ $tmpdir/stats.$$ $tmpdir/vol.$$

exit $status
