#! /bin/sh

echo "running test4.sh for kextract ... process ($$)"


# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num=$1
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0


# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb SAMPLEDATA -echo path`
dpath="$tbpath/data/sequences/numbers"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  1:  extract bit image with mask, 3w 16h offset
# ------------------------------------------------------------------------
test_num=1a
descr="extract bit w/mask, 3w 16h offset - compare bit, ubyte extraction"
kcpfromval -i $dpath/xbm.0-9/mask.00 -o $tmpdir/out.$$ -mask
kinsertseg -i1 $tmpdir/out.$$ -i2 $dpath/xbm.0-9/image.00 -mask \
	   -o $tmpdir/bitdata.$$
kcpfromval -i $dpath/xvimage_byte.0-9/mask.00 -o $tmpdir/out.$$ -mask
kinsertseg -i1 $tmpdir/out.$$ -i2 $dpath/xvimage_byte.0-9/image.00 -mask \
	   -o $tmpdir/ubytedata.$$ 
kextract -i $tmpdir/bitdata.$$ -o $tmpdir/bitout.$$ -subpos TRUE -wsize 37 -hsize 35 -woff 3 -hoff 16 

kconvert -i $tmpdir/bitout.$$ -o $tmpdir/converted.$$ -type "unsigned byte" -val
kconvert -i $tmpdir/converted.$$ -o $tmpdir/converted.$$ -type "unsigned byte" -mask
kextract -i $tmpdir/ubytedata.$$ -o $tmpdir/ubyteout.$$ \
	 -subpos TRUE -wsize 37 -hsize 35 -woff 3 -hoff 16
report $test_num "$tmpdir/converted.$$" "$tmpdir/ubyteout.$$" "$descr"

test_num=1b
descr="extract bit w/mask, 3w 16h offset - inset into ubyte image w/mask"
kinset -i2 $tmpdir/bitout.$$ -i1 $tmpdir/ubytedata.$$ -o $tmpdir/out.$$ 
report $test_num "$tmpdir/out.$$" "$tmpdir/ubytedata.$$" "$descr"

/bin/rm -f $tmpdir/bitout.$$ $tmpdir/converted.$$ $tmpdir/ubyteout.$$
/bin/rm -f $tmpdir/out.$$
/bin/rm -f $tmpdir/bitdata.$$
/bin/rm -f $tmpdir/ubytedata.$$

# ------------------------------------------------------------------------
# Test  2:  extract bit image, 5w 9h offset
# ------------------------------------------------------------------------
test_num=2a
descr="extract bit, 5w 9h offset - compare bit, ubyte extraction"
kextract -i $dpath/xbm.0-9/image.00 -o $tmpdir/bitout.$$ -subpos TRUE -wsize 45 -hsize 35 -woff 5 -hoff 9
kconvert -i $tmpdir/bitout.$$ -o $tmpdir/converted.$$ -type "unsigned byte" -val
kextract -i $dpath/xvimage_byte.0-9/image.00 -o $tmpdir/ubyteout.$$ \
	 -subpos TRUE -wsize 45 -hsize 35 -woff 5 -hoff 9
report $test_num "$tmpdir/converted.$$" "$tmpdir/ubyteout.$$" "$descr"

test_num=2b
descr="extract bit, 5w 9h offset - inset into ubyte image"
kinset -i1 $tmpdir/bitout.$$ -i2 $dpath/xvimage_byte.0-9/image.00 \
       -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "$dpath/xvimage_byte.0-9/image.00" "$descr"

/bin/rm -f $tmpdir/bitout.$$ $tmpdir/converted.$$ $tmpdir/ubyteout.$$
/bin/rm -f $tmpdir/out.$$

# ------------------------------------------------------------------------
# Test  3:  extract bit image, 0 offset
# ------------------------------------------------------------------------
test_num=3a
descr="extract bit, 0 offset - compare bit, ubyte extraction"
kextract -i $dpath/xbm.0-9/image.00 -o $tmpdir/bitout.$$ -subpos TRUE \
	 -wsize 45 -hsize 55
kconvert -i $tmpdir/bitout.$$ -o $tmpdir/converted.$$ -type "unsigned byte" -val
kextract -i $dpath/xvimage_byte.0-9/image.00 -o $tmpdir/ubyteout.$$ \
	 -subpos TRUE -wsize 45 -hsize 55
report $test_num "$tmpdir/converted.$$" "$tmpdir/ubyteout.$$" "$descr"

test_num=3b
descr="extract bit, 0 offset - inset into ubyte image"
kinset -i1 $tmpdir/bitout.$$ -i2 $dpath/xvimage_byte.0-9/image.00 \
       -o $tmpdir/out.$$
report $test_num "$tmpdir/out.$$" "$dpath/xvimage_byte.0-9/image.00" "$descr"

/bin/rm -f $tmpdir/bitout.$$ $tmpdir/converted.$$ $tmpdir/ubyteout.$$
/bin/rm -f $tmpdir/out.$$

exit $status
