#! /bin/sh

echo "running test1.sh for kextract ... process ($$)"

# ------------------------------------------------------------------------
#  set path for temporary directory
# ------------------------------------------------------------------------
tmpdir=${TMPDIR:-/tmp}

kextract -i image:head -o $tmpdir/ref.$$  -woff 10 -hoff 10 -doff 0 -toff 0 \
	 -eoff 0 -wsize 246 -hsize 218 -tsize 1 -dsize 1 -esize 1 -subpos FALSE

kextract -i image:head -o $tmpdir/junk.$$ -woff 0 -hoff 0 -doff 0 -toff 0 \
	 -eoff 0 -wsize 300 -hsize 300 -tsize 1 -dsize 1 -esize 1 -subpos FALSE

kextract -i $tmpdir/junk.$$ -o $tmpdir/junk2.$$ -woff 10 -hoff 10 -doff 0 \
	 -toff 0 -eoff 0 -wsize 246 -hsize 218 -tsize 1 -dsize 1 -esize 1 \
	 -subpos FALSE

# echo  " "
# echo  " Done extracting data "
# echo  " Subtracting two output objects for comparison "
# echo  " "

karith2 -i1 $tmpdir/junk2.$$ -i2 $tmpdir/ref.$$ -o $tmpdir/diff.$$ -sub

kstats -all -i $tmpdir/diff.$$ -o $tmpdir/stats.$$

ksegcmp -i1 $tmpdir/stats.$$ -i2 test1.results/stats -tol 1e-5 -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  check on extracting value data passed"
   status=0
else
   echo "FAILED:  check on extracting value data failed."
   status=1
fi

/bin/rm -f $tmpdir/ref.$$ $tmpdir/junk2.$$ $tmpdir/junk.$$ $tmpdir/diff.$$ $tmpdir/stats.$$

exit $status
