#! /bin/sh

echo "running test1c.sh for karith1 ... process ($$)"

# ------------------------------------------------------------------------
# report test_num test_obj cntrl_obj test_descr
#
# The report function uses ksegcmp to compare the test output data object
# ($2) against the correct result ($3), and reports success or failure of
# the test.  If the result of ksegcmp is false, status is set to 1.
# ------------------------------------------------------------------------
report()
{
test_num="$1"
test_obj="$2"
cntrl_obj="$3"
test_descr="$4"
tolerance="$5"

ksegcmp -i1 "$test_obj" -i2 "$cntrl_obj" -tol "$tolerance" -sat 1 -s -rt 1 -all
if [ $? = 0 ]
then
   echo "Passed:  Test  $test_num --> "$test_descr""
else
   echo "FAILED:  Test  $test_num --> "$test_descr""
   status=1
fi
}

#
#  Initialize status to be success (ie. 0).  Upon failure, status is
#  initialized to 1.
#
status=0

# ------------------------------------------------------------------------
#  set path for test data, and path for temporary directory
# ------------------------------------------------------------------------
tbpath=`kecho -tb DATAMANIP -echo path`
dpath="$tbpath/data/testdata"
tmpdir=${TMPDIR:-/tmp}

# ------------------------------------------------------------------------
# Test  31:  recip - float value data with no map
# ------------------------------------------------------------------------
test_num=31a
descr="recip - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
-1 1
57 -1e20
-65536 -1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -recip
cat <<EOF > $tmpdir/ascii.$$
-1 1
0.017543859 -1e-20
-1.52587890e-5 -1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

test_num=31b
descr="recip - float value data with no map - very small value"
cat <<EOF > $tmpdir/ascii.$$
1.12345e-20
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -recip
cat <<EOF > $tmpdir/ascii.$$
8.901152678e19
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 1 -hsize 1 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e+12"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  32:  sin - float value data with no map
# ------------------------------------------------------------------------
test_num=32
descr="sin - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
1.5707963 -1.5707963
2.3561945 -3.1415926
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -sin
cat <<EOF > $tmpdir/ascii.$$
0 0.84147098
1.0 -1.0
0.70710678 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  33:  cos - float value data with no map
# ------------------------------------------------------------------------
test_num=33
descr="cos - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
1.5707963 -1.5707963
2.3561945 -3.1415926
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -cos
cat <<EOF > $tmpdir/ascii.$$
1 0.54030231
0.0 0.0
-0.70710678 -1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  34:  asin - float value data with no map
# ------------------------------------------------------------------------
test_num=34
descr="asin - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 0.84147098
1.0 -1.0
0.70710678 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -asin
cat <<EOF > $tmpdir/ascii.$$
0 1
1.5707963 -1.5707963
0.78539816 0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  35:  acos - float value data with no map
# ------------------------------------------------------------------------
test_num=35
descr="acos - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
1.5707963 -1.5707963
2.3561945 -3.1415926
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -cos
cat <<EOF > $tmpdir/ascii.$$
1 0.54030231
0.0 0.0
-0.70710678 -1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  36:  tan - float value data with no map
# ------------------------------------------------------------------------
test_num=36
descr="tan - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0.78539816 0
-0.78539816 1
-1 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -tan
cat <<EOF > $tmpdir/ascii.$$
1 0
-1 1.5574077
-1.5574077 0.54630249
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  37:  atan - float value data with no map
# ------------------------------------------------------------------------
test_num=37
descr="atan - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
1 0
-1 1.5574077
-1.5574077 0.54630249
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -atan
cat <<EOF > $tmpdir/ascii.$$
 0.7853981853 0
-0.7853981853 1
-1 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  38:  sinh - float value data with no map
# ------------------------------------------------------------------------
test_num=38
descr="sinh - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
-1 2
-2 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -sinh
cat <<EOF > $tmpdir/ascii.$$
0 1.1752
-1.1752 3.62686
-3.62686 0.521095
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  39:  asinh - float value data with no map
# ------------------------------------------------------------------------
test_num=39
descr="asinh - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1.1752
-1.1752 3.62686
-3.62686 0.521095
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -asinh
cat <<EOF > $tmpdir/ascii.$$
0 1
-1 2
-2 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  40:  cosh - float value data with no map
# ------------------------------------------------------------------------
test_num=40
descr="cosh - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
-1 2
-2 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -cosh
cat <<EOF > $tmpdir/ascii.$$
1 1.54308
1.54308 3.7622
3.7622 1.12763
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  41:  acosh - float value data with no map
# ------------------------------------------------------------------------
test_num=41
descr="acosh - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
1 1.54308
1.54308 3.7622
3.7622 1.12763
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -acosh
cat <<EOF > $tmpdir/ascii.$$
0 1
1 2
2 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  42:  tanh - float value data with no map
# ------------------------------------------------------------------------
test_num=42
descr="tanh - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1
-1 3
-3 0.5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -tanh
cat <<EOF > $tmpdir/ascii.$$
0 0.761594
-0.761594 0.995054
-0.995054 0.462117
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  43:  atanh - float value data with no map
# ------------------------------------------------------------------------
test_num=43
descr="atanh - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 0.761594
-0.761594 0.995054
-0.995054 0.462117
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -atanh
cat <<EOF > $tmpdir/ascii.$$
0 0.99999964
-0.99999964 2.99992418
-2.99992418 0.49999979
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  44:  sinc - float value data with no map
# ------------------------------------------------------------------------
test_num=44
descr="sinc - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 1.5707963
-1.5707963 0.785339816
-0.785339816 3.1415926
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -sinc
cat <<EOF > $tmpdir/ascii.$$
1 0.63661980
0.63661980 0.90033066
0.90033066 0.0
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

# ------------------------------------------------------------------------
# Test  45:  ceil - float value data with no map
# ------------------------------------------------------------------------
test_num=45
descr="ceil - float value data with no map"
cat <<EOF > $tmpdir/ascii.$$
0 0.99
-0.99 1.01
-1.01 1.0001e-5
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/ascii.$$
karith1 -i $tmpdir/ascii.$$ -o $tmpdir/out.$$ -ceil
cat <<EOF > $tmpdir/ascii.$$
0 1
0 2
-1 1
EOF
kasc2val -i1 $tmpdir/ascii.$$ -wsize 2 -hsize 3 -type 10 -o $tmpdir/result.$$
report $test_num "$tmpdir/out.$$" "$tmpdir/result.$$" "$descr" "1e-5"
/bin/rm -f $tmpdir/out.$$ $tmpdir/result.$$ $tmpdir/ascii.$$

exit $status

