 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for krmseg
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkrmseg
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkrmseg - delete specified segments from an object creating new object
* 
*       Purpose: This routine will copy the source_object to the
*		 destination_object then delete the segment(s)
*		 specified by segment_list from the destination_object.
*		 Each segment's attributes and data will be delete.
*		 If segment_list is NULL it will delete all the
*		 segments in the object, but leave all object
*		 level attributes.  The segment_list is a string
*		 that contains each segment name separated by space(s).
*		
*        !     lkrmseg(source_object, "segment1 segment2",
*        !                      destination_object);
*		
*		 If the segment does not exist an error message is
*		 printed, but will not return until an attempt to delete
*		 all the segments has been done.
*
*         Input: source_object - object to delete the segment from
*                segment_list  - name of segment to delete
*
*        Output: destination_object - object without the segment(s)
*       Returns: TRUE (1) if one deleted, FALSE (0) if none deleted
*
*  Restrictions: 
*    Written By: John M. Salas & Donna Koechner
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: 
* Modifications: 
****************************************************************/
/* -library_def */
int 
lkrmseg(
   kobject source_object,
   char   *segment_list,
   kobject destination_object)
/* -library_def_end */

/* -library_code */
{
   char **segment_names;
   int    count;
   int    failure = TRUE;
   int    i;
   klist *segment;
   klist *list;

   if (!kdms_copy_object(source_object, destination_object, TRUE, TRUE))
   {
      kerror("ksegops", "lkrmseg", 
	     "Failed to duplicate source object to destination object.");
      return (FALSE);
   }

   /*
    * If segment_list is NULL delete all the segments using the
    * the kdms_get_segment_list() routine that returns all the
    * segments that exist in the object.  The list identifier
    * is the token of the segment's name and needs to be translated
    * using the ktoken_to_string() routine.
    */
   if (!segment_list)
   {
      list = kdms_get_segment_list(destination_object);

      if (!list)
      {
	 kerror("ksegops", "lkrmseg", 
		"There are no segments to delete");
	 return (FALSE);
      }

      for (segment = klist_head(list); segment != NULL;
	   segment = klist_next(segment))
      {
	 if (!kdms_destroy_segment(destination_object,
			  ktoken_to_string((int)klist_identifier(segment))))
	 {
	    kerror("ksegops", "lkrmseg", "Failed to delete \
segment %s from object.", ktoken_to_string((int)klist_identifier(segment)));
	 }
	 else
	 {
	    failure = FALSE;
	 }
      }

      /* if uniform location still exists then destroy it! */
      if (kpds_query_location(destination_object))
	 kpds_destroy_location(destination_object);
   }
   /*
    * If segment_list not NULL parse out the segment names using
    * kparse_string_delimit() and delete them one at a time.  Print
    * a message if a delete fails, but continue to delete segments until
    * attempts to delete all the segments have been done.
    */
   else
   {
      segment_names =
	 kparse_string_delimit(segment_list, " ", KDELIM_CLEAN, &count);

      for (i = 0; i < count; i++)
      {
	 /* location is a special case in pds */
	 if (kstrcmp(segment_names[i], KDMS_SEGMENT_LOCATION) == 0)
	 {
	    if (!kpds_destroy_location(destination_object))
	    {
	       kerror("ksegops", "lkrmseg", "Failed to delete "
		      "location segment from object.", segment_names[i]);
	    }
	    else 
	       failure = FALSE;
	 }
	 else if (!kdms_destroy_segment(destination_object, segment_names[i]))
	 {

	    kerror("ksegops", "lkrmseg", "Failed to delete \
segment %s from object.", segment_names[i]);
	 }
	 else
	 {
	    failure = FALSE;
	 }
      }
   }

   /*
    * If one of the segments were successfully deleted return !failure.
    */
   return (!failure);
}
/* -library_code_end */
