 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Library Routine for kgconst
   >>>> 
   >>>>  Private: 
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 	lkgconst
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "internals.h"

/* -library_includes */
/* -library_includes_end */


/****************************************************************
* 
*  Routine Name: lkgconst - set value segment of a data object to a constant
* 
*       Purpose: Library Routine for kgconst.  lkgconst creates a
*                constant valued value segment for the destination 
*                data object.  The resulting data size is specified by 
*		 the wsize, hsize, dsize, tsize, and esize parameters.
*		 The data type of the value segment is specified by 
*                the datatype parameter, and can be KBIT, KBYTE, KUBYTE,
*                KSHORT, KUSHORT, KINT, KUINT, KLONG, KULONG, KFLOAT, 
*                KDOUBLE, KCOMPLEX and KDCOMPLEX.  The value segment will 
*		 be set to the real and imaginary constant levels specified 
*		 by the "real" and "imaginary" parameters.
*
*         Input: wsize	   - The wsize of the object being created
*                hsize	   - the height of the object being created
*                dsize	   - the depth of the object being created
*                tsize	   - the size of the objects time dimension 
*                esize     - the objects element dimension size
*                real	   - the real component of the constant value
*                imaginary - imaginary component of the constant value
*                datatype  - datatype value (see above)
*        Output: object	   - the output object
*
*       Returns: TRUE (1) on success, FALSE (0) on failure
*  Restrictions: 
*    Written By: Donna Koechner
*          Date: Apr 08, 1995
*      Verified: 
*  Side Effects: If the value segment already exists, then all data
*		 in the segment will be overwritten with the constant
*		 value in the data type specified in the function call
*		 and the size will be changed to the specfied wsize,
*		 hsize, dsize, tsize and esize.
* Modifications: 
****************************************************************/
/* -library_def */
int lkgconst(
   int     wsize,
   int     hsize,
   int     dsize,
   int     tsize,
   int     esize,
   double  real,
   double  imaginary,
   int     datatype,
   kobject object)
/* -library_def_end */

/* -library_code */
{
   int  i;
   char *lib="kdatamanip", *prog="lkgconst";
   
   /*
    * A few sanity checks should be performed to ensure that the
    * arguments passed in are meaningful.  Its a good idea to 
    * check the validity of the size arguments and the object.
    */
   if (object == KOBJECT_INVALID) 
   {
      kerror (lib, prog, "The object argument must be a valid data object.");
      return (FALSE);
   }
   
   if (wsize <= 0 || hsize <= 0 || dsize <= 0 || tsize <= 0 || esize <= 0) 
   {
      kerror (lib, prog, "The size arguments must all be greater than zero.");
      return (FALSE);
   }

   /*
    * The existence of the value segment is checked because the object 
    * that is passed in may have been used previously.  If the value 
    * segment does not exist, then create it.  If you don't create it, 
    * future function calls that operate on the value segment will fail.
    */
   if (!kpds_query_value(object))
   {
      if (!kpds_create_value(object))
      {
         kerror (lib, prog, "Unable to create value data segment");
         return (FALSE);
      }
   }
   
   /*
    * Set the size and datatype attributes of the value segment.
    */
   if (!kpds_set_attributes(object,
           KPDS_VALUE_SIZE, wsize, hsize, dsize, tsize, esize,
           KPDS_VALUE_DATA_TYPE, datatype,
           NULL)) 
   {
      kerror (lib, prog, "Unable to value segment attributes.");
      return(FALSE);
   }
   
   /* 
    * Initialize the data segment with the values passed in. The 
    * initialization routine should be using optimal regions to set
    * up the data segment, so memory access will be optimized. 
    */
   if (!kpds_initialize_value(object, real, imaginary))
   {
      kerror("kdatamanip", "lkgconst",
         "Unable to initialize object value datas.");
      return(FALSE);
   }

   return(TRUE);
}
/* -library_code_end */
