 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kunmask
   >>>> 
   >>>>    Written By: Donna Koechner and Steve Kubica
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kunmask_h_
#define _kunmask_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kunmask/uis/kunmask.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input data object (required infile)
 */
char	*i_file;	/* Input data object FILENAME */
int	 i_flag;	/* Input data object FLAG */

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*
 *  If replace selected, replace real data with this value (optional double)
 */
double	 real_double;	/* If replace selected, replace real data with this value DOUBLE */
int	 real_flag;   	/* If replace selected, replace real data with this value FLAG */

/*
 *  If replace selected, replace imaginary data with this value (optional double)
 */
double	 imag_double;	/* If replace selected, replace imaginary data with this value DOUBLE */
int	 imag_flag;   	/* If replace selected, replace imaginary data with this value FLAG */

/*----- optional ME group ----*/
/*
 *  Propagate masked (invalid) data to output (optional flag)
 */
int	 prop_flag;  	/* Propagate masked (invalid) data to output FLAG */

/*
 *  Replace masked (invalid) data with real/imag values (optional flag)
 */
int	 replace_flag;  	/* Replace masked (invalid) data with real/imag values FLAG */

/*
 *  Process as defined by the object mask attributes (optional flag)
 */
int	 attr_flag;  	/* Process as defined by the object mask attributes FLAG */

/*-- optional ME group end ---*/

/*----- optional MI group ----*/
/*
 *  Output file containing mask that was removed (optional outfile)
 */
char	*omask_file;	/* Output file containing mask that was removed FILENAME */
int	 omask_flag;	/* Output file containing mask that was removed FLAG */

	/*---- nested optional ME group ----*/
/*
 *  If selected, save input mask as mask data in omask object (optional flag)
 */
int	 mask_flag;  	/* If selected, save input mask as mask data in omask object FLAG */

/*
 *  If selected, save input mask as value data in omask object (optional flag)
 */
int	 val_flag;  	/* If selected, save input mask as value data in omask object FLAG */

	/*-- nested optional ME group end --*/

/*-- optional MI group end ---*/

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kunmask_get_args PROTO((kform *));
void kunmask_usage_additions PROTO((void));
void kunmask_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
