 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kunmask
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kunmask.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Remove Mask from Data Object
|
|       Purpose: main program for kunmask
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {Resulting output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->real_double; {If replace selected, replace real data with this value}
|		int    clui_info->real_flag; {TRUE if -real specified}
|
|		double clui_info->imag_double; {If replace selected, replace imaginary data with this value}
|		int    clui_info->imag_flag; {TRUE if -imag specified}
|
|		Optional M.E. group:
|		    int clui_info->prop_flag; {TRUE if -prop specified}
|
|		    int clui_info->replace_flag; {TRUE if -replace specified}
|
|		    int clui_info->attr_flag; {TRUE if -attr specified}
|
|		M.I. group:
|		    char *clui_info->omask_file; {Output file containing mask that was removed}
|		    int   clui_info->omask_flag; {TRUE if -omask specified}
|
|		    Optional M.E. group:
|			int clui_info->mask_flag; {TRUE if -mask specified}
|
|			int clui_info->val_flag; {TRUE if -val specified}
|
|        Output:
|       Returns:
|
|    Written By: Donna Koechner and Steve Kubica
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject	src_obj=NULL, dst_obj=NULL, mask_obj=NULL;
	int     ow, oh, od, ot, oe, num_regions;
	kaddr   data=NULL;
	int     i;
	int     replace = FALSE;
	int     masked_presented;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kunmask_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kunmask",
		kunmask_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kunmask_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/*
	 *  Open the input and output data objects.
	 */
        if ((src_obj = kpds_open_input_object(clui_info->i_file)) 
                == KOBJECT_INVALID)
        {
           kerror("kunmask","main", "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((dst_obj = kpds_open_output_object(clui_info->o_file)) 
                == KOBJECT_INVALID)
        {
           kerror("kunmask","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if ((clui_info->omask_flag) && 
	     (mask_obj = kpds_open_output_object(clui_info->omask_file)) 
                == KOBJECT_INVALID)
        {
           kerror("kunmask","main", "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

	/*
	 *  If none of the processing flags were set, default to using the
	 *  object's mask attributes, if any exist.  If they don't the 
	 *  default chosen by kpds will be KNONE.
	 */
	if ((!clui_info->prop_flag) && (!clui_info->replace_flag) && 
	    (!clui_info->attr_flag) )
	   clui_info->attr_flag = TRUE;

	if (clui_info->prop_flag)
	{
	   if (!kpds_set_attribute(src_obj, KPDS_MASKED_VALUE_PRESENTATION, 
				   KUSE_ORIGINAL))
	   {
	      kerror("kunmask","main", 
		     "Cannot set input object mask attributes.");
	      kexit(KEXIT_FAILURE);
	   }
	}
	else if (clui_info->replace_flag)
	{ 
	   if (!kpds_set_attributes(src_obj, KPDS_MASKED_VALUE_PRESENTATION, 
				    KUSE_SUBSTITUTE_VALUE,
				    KPDS_MASK_SUBSTITUTE_VALUE, 
				    clui_info->real_double, 
				    clui_info->imag_double, NULL))
	   {
	      kerror("kunmask","main", 
		     "Cannot set input object mask attributes.");
	      kexit(KEXIT_FAILURE);
	   }
	   
	   replace = TRUE;
	}
	else if (clui_info->attr_flag)
	{
	   if (!kpds_get_attribute(src_obj, KPDS_MASKED_VALUE_PRESENTATION,
				   &masked_presented))
	   {
	      kerror("kunmask","main",
		     "Cannot get input object masked value presentation");
	      kexit(KEXIT_FAILURE);
	   }
	   
	   if (masked_presented == KUSE_SUBSTITUTE_VALUE)
	      replace = TRUE;
	}
		    
	
	/* copy absolutely everything in the object over */
	/* copy attributes in the source object object over */
	if (!kpds_copy_object_attr(src_obj, dst_obj))
	{
           kerror("kunmask","main", 
		  "Unable to copy attributes from input object to output.");
	   kexit(KEXIT_FAILURE);
	}

/* print attributes for debugging
kpds_print_attribute(src_obj, KPDS_MASKED_VALUE_PRESENTATION, kstdout);
kinfo(KSTANDARD, " <-- src_obj KPDS_MASKED_VALUE_PRESENTATION");
kpds_print_attribute(src_obj, KPDS_MASK_SUBSTITUTE_VALUE, kstdout);
kinfo(KSTANDARD, " <-- src_obj KPDS_MASK_SUBSTITUTE_VALUE");
kpds_print_attribute(dst_obj, KPDS_MASKED_VALUE_PRESENTATION, kstdout);
kinfo(KSTANDARD, " <-- dst_obj KPDS_MASKED_VALUE_PRESENTATION");
kpds_print_attribute(dst_obj, KPDS_MASK_SUBSTITUTE_VALUE, kstdout);
kinfo(KSTANDARD, " <-- dst_obj KPDS_MASK_SUBSTITUTE_VALUE");
*/
	/* recopy the value to be unmasked using the replacement value */
	if (replace)
	{
	   /* verify that there is value data to unmask */
	   if (!kpds_query_value(src_obj))
	   {
	      kerror("kunmask","main",
		     "Input does not contain value data");
	      kexit(KEXIT_FAILURE);
	   }
	   
	   /* get the optimal region size from the source */ 
	   if (!kpds_get_attribute(src_obj, KPDS_VALUE_OPTIMAL_REGION_SIZE, 
				   &ow, &oh, &od, &ot, &oe, &num_regions))
	   {
              kerror("kunmask","main", 
		     "Unable to retreive the optimimum region size for input");
	      kexit(KEXIT_FAILURE);
	   }

	   /* set the position and region sizes on both the input and output */
      	   if (!kpds_set_attributes(src_obj,
			       KPDS_VALUE_POSITION, 0, 0, 0, 0, 0,
			       KPDS_VALUE_REGION_SIZE, ow, oh, od, ot, oe,
			       NULL))
	   {
              kerror("kunmask","main", 
		     "Unable to set the position and region size on input");
	      kexit(KEXIT_FAILURE);
	   }

      	   if (!kpds_set_attributes(dst_obj,
			       KPDS_VALUE_REGION_SIZE, ow, oh, od, ot, oe,
			       KPDS_VALUE_POSITION, 0, 0, 0, 0, 0,
			       NULL))
	   {
              kerror("kunmask","main", 
		     "Unable to set the position and region size on output");
	      kexit(KEXIT_FAILURE);
	   }

 	   /* copy the data using the pds get'n'put data calls */
	   for (i = 0; i < num_regions; i++)
           {
	      data = kpds_get_data(src_obj, KPDS_VALUE_REGION, data);
	      kpds_put_data(dst_obj, KPDS_VALUE_REGION, data);
           }

	   /* the masked value interpretation on the destination is now 
	      to use the original */
	   if (!kpds_set_attribute(dst_obj, 
			   KPDS_MASKED_VALUE_PRESENTATION, KUSE_ORIGINAL))
	   {
              kerror("kunmask","main", 
		     "Unable to set the masked value presentation on output");
	      kexit(KEXIT_FAILURE);
	   }
	}

	/* the data is now unmasked -- get rid of excess mask baggage */
	if (!kpds_destroy_mask(dst_obj))
	{
           kerror("kunmask","main", "Unable to remove output object mask.");
	   kexit(KEXIT_FAILURE);
	}
	
	if (clui_info->omask_flag)
	{
	   if (clui_info->val_flag)
	   {
              if (!lkcptoval(src_obj, KDMS_SEGMENT_MASK, mask_obj))
              {
                 kerror("kunmask","main", 
			"Unable to copy mask to output mask object.");
                 kexit(KEXIT_FAILURE);
              }
	   }

	   else 
	   {
	      if (!kpds_copy_mask(src_obj, mask_obj, TRUE))
	      {
                 kerror("kunmask","main", 
			"Unable to copy mask to output mask object.");
	         kexit(KEXIT_FAILURE);
	      }
	   }
	}
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(dst_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kunmask", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

	if (!kpds_copy_remaining_data(src_obj, dst_obj))
	{
           kerror("kunmask","main", 
		  "Unable to copy remaining data from input object to output.");
	   kexit(KEXIT_FAILURE);
	}

	kpds_close_object(src_obj);
	kpds_close_object(dst_obj);
	if (clui_info->omask_flag) kpds_close_object(mask_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kunmask_usage_additions
| 
|       Purpose: Prints usage additions in kunmask_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kunmask
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kunmask_usage_additions(void)
{
	kfprintf(kstderr, "\tRemove Mask from Data Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kunmask_free_args
| 
|       Purpose: Frees CLUI struct allocated in kunmask_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kunmask
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kunmask_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
	kfree(clui_info->omask_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
