 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kshot
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kshot.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Introduce Shot Noise in Input Object
|
|       Purpose: main program for kshot
|
|         Input:
|		char *clui_info->i_file; {Input File}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		double clui_info->spikes_double; {Percentage of spikes in the output}
|		int    clui_info->spikes_flag; {TRUE if -spikes specified}
|
|		char *clui_info->o_file; {Output File}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		double clui_info->real_double; {Real value of spike }
|		int    clui_info->real_flag; {TRUE if -real specified}
|
|		double clui_info->imag_double; {Imaginary value of spike}
|		int    clui_info->imag_flag; {TRUE if -imag specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject in_obj;
        kobject out_obj;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kshot_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kshot",
		kshot_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kshot_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((in_obj  = kpds_open_input_object(clui_info->i_file)) == NULL)
        {
           kerror("kshot","main",
                  "Cannot open input object.");
           kexit(KEXIT_FAILURE);
        }

        if ((out_obj = kpds_open_output_object(clui_info->o_file)) == NULL)
        {
           kerror("kshot","main",
                  "Cannot open output object.");
           kexit(KEXIT_FAILURE);
        }

        if (!kpds_copy_object(in_obj, out_obj))
        {
           kerror("kshot","main",
                  "Cannot copy input object to output object.");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkshot(in_obj, clui_info->spikes_double,
                    clui_info->real_double, clui_info->imag_double,
                    out_obj))
           kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kshot", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(in_obj);
        kpds_close_object(out_obj);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kshot_usage_additions
| 
|       Purpose: Prints usage additions in kshot_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kshot
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kshot_usage_additions(void)
{
	kfprintf(kstderr, "\tIntroduce Shot Noise in Input Object\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kshot_free_args
| 
|       Purpose: Frees CLUI struct allocated in kshot_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kshot
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kshot_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
