 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kreal2cmplx
   >>>> 
   >>>>    Written By: Donna Koechner
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kreal2cmplx_h_
#define _kreal2cmplx_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kreal2cmplx/uis/kreal2cmplx.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Resulting output data object (required outfile)
 */
char	*o_file;	/* Resulting output data object FILENAME */
int	 o_flag;	/* Resulting output data object FLAG */

/*----- required   group ----*/
/*
 *  Input to be used as real component (optional infile)
 */
char	*i1_file;	/* Input to be used as real component FILENAME */
int	 i1_flag;	/* Input to be used as real component FLAG */

/*
 *  Input to be used as imaginary component (optional infile)
 */
char	*i2_file;	/* Input to be used as imaginary component FILENAME */
int	 i2_flag;	/* Input to be used as imaginary component FLAG */

/*-- required   group end ---*/

/*
 *  Value to be used as real component if no i1, or if padding occurs (optional double)
 */
double	 real_double;	/* Value to be used as real component if no i1, or if padding occurs DOUBLE */
int	 real_flag;   	/* Value to be used as real component if no i1, or if padding occurs FLAG */

/*
 *  Value to be used as imaginary component if no i2, or if padding occurs (optional double)
 */
double	 imag_double;	/* Value to be used as imaginary component if no i2, or if padding occurs DOUBLE */
int	 imag_flag;   	/* Value to be used as imaginary component if no i2, or if padding occurs FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kreal2cmplx_get_args PROTO((kform *));
void kreal2cmplx_usage_additions PROTO((void));
void kreal2cmplx_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
