 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kprval
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kprval.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Print Data Value to Parser and/or Concatenate to File
|
|       Purpose: main program for kprval
|
|         Input:
|		char *clui_info->i_file; {Input data object}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		Required M.E. group:
|		    int clui_info->val_flag; {TRUE if -val specified}
|
|		    int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mask_flag; {TRUE if -mask specified}
|
|		    int clui_info->time_flag; {TRUE if -time specified}
|
|		    M.I. group:
|			int clui_info->loc_flag; {TRUE if -loc specified}
|
|			int clui_info->dimoff_int; {offset of point along location dimension}
|			int clui_info->dimoff_flag; {TRUE if -dimoff specified}
|
|		int clui_info->mapdata_logic; {map value data through the map before processing}
|		int clui_info->mapdata_flag; {TRUE if -mapdata specified}
|
|		int clui_info->woff_int; {offset of point along width dimension}
|		int clui_info->woff_flag; {TRUE if -woff specified}
|
|		int clui_info->hoff_int; {offset of point along height dimension}
|		int clui_info->hoff_flag; {TRUE if -hoff specified}
|
|		int clui_info->doff_int; {offset of point along depth dimension}
|		int clui_info->doff_flag; {TRUE if -doff specified}
|
|		int clui_info->toff_int; {offset of point along time dimension}
|		int clui_info->toff_flag; {TRUE if -toff specified}
|
|		int clui_info->eoff_int; {offset of point along elements dimension}
|		int clui_info->eoff_flag; {TRUE if -eoff specified}
|
|		char *clui_info->var_string; {Name of variable to which output value is assigned}
|		int   clui_info->var_flag; {TRUE if -var specified}
|
|		char *clui_info->o_file; {Output ASCII in which to append data value}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|        Output:
|       Returns:
|
|    Written By: 
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
	kobject	src_obj;
	char	*lib="main", *rtn="kprval";
	int	woff, hoff, doff, toff, eoff, dimoff;
        kfile   *ascii_out=NULL;
	double	*data=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kprval_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kprval",
		kprval_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kprval_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
	/* open source object */
	if ((src_obj = kpds_open_input_object(clui_info->i_file))
		 == KOBJECT_INVALID)
	{
	   kerror(lib,rtn,"unable to open input object %s",clui_info->i_file);
	   kexit(KEXIT_FAILURE);
	}
	
	/* get offset values */
	woff = clui_info->woff_int;
	hoff = clui_info->hoff_int;
	doff = clui_info->doff_int;
	toff = clui_info->toff_int;
	eoff = clui_info->eoff_int;
	dimoff = clui_info->dimoff_int;

	if (clui_info->mapdata_logic)
	kpds_set_attribute(src_obj, KPDS_MAPPING_MODE, KMAPPED);

	if (clui_info->val_flag && kpds_query_value(src_obj))
	{
	   if (!kpds_set_attributes(src_obj, 
			KPDS_VALUE_DATA_TYPE, KDOUBLE,
			KPDS_VALUE_OFFSET, woff, hoff, doff, toff, eoff,
			NULL))
	   {
	      kerror(lib,rtn,"unable to set source object value attributes");
	      kexit(KEXIT_FAILURE);
	   }
	   data = kpds_get_data(src_obj, KPDS_VALUE_POINT, data);
	}

	else if (clui_info->map_flag && kpds_query_map(src_obj))
	{
	   if (!kpds_set_attributes(src_obj, 
			KPDS_MAP_DATA_TYPE, KDOUBLE,
			KPDS_MAP_OFFSET, woff, hoff, doff, toff, eoff,
			NULL))
	   {
	      kerror(lib,rtn,"unable to set source object map attributes");
	      kexit(KEXIT_FAILURE);
	   }
	   data = kpds_get_data(src_obj, KPDS_MAP_POINT, data);
	}
	
	else if (clui_info->mask_flag && kpds_query_mask(src_obj))
	{
	   if (!kpds_set_attributes(src_obj, 
			KPDS_MASK_DATA_TYPE, KDOUBLE,
			KPDS_MASK_OFFSET, woff, hoff, doff, toff, eoff,
			NULL))
	   {
	      kerror(lib,rtn,"unable to set source object mask attributes");
	      kexit(KEXIT_FAILURE);
	   }
	   data = kpds_get_data(src_obj, KPDS_MASK_POINT, data);
	}
	
	else if (clui_info->loc_flag && kpds_query_location(src_obj))
	{
	   if (!kpds_set_attributes(src_obj, 
			KPDS_LOCATION_DATA_TYPE, KDOUBLE,
			KPDS_LOCATION_OFFSET, woff, hoff, doff, dimoff, 
			NULL))
	   {
	      kerror(lib,rtn,"unable to set source object location attributes");
	      kexit(KEXIT_FAILURE);
	   }
	   data = kpds_get_data(src_obj, KPDS_LOCATION_POINT, data);
	}
	
	else if (clui_info->time_flag && kpds_query_time(src_obj))
	{
	   if (!kpds_set_attributes(src_obj, 
			KPDS_TIME_DATA_TYPE, KDOUBLE,
			KPDS_TIME_OFFSET, toff, 
			NULL))
	   {
	      kerror(lib,rtn,"unable to set source object time attributes");
	      kexit(KEXIT_FAILURE);
	   }
	   data = kpds_get_data(src_obj, KPDS_TIME_POINT, data);
	}

	else
	{
	   kerror(lib,rtn,"Unrecognized data segment specified");
	   kexit(KEXIT_FAILURE);
	}

	if (clui_info->var_flag)
	   kprintf("%s = %g\n", clui_info->var_string, data[0]);

	/* Open the ASCII output file if it was specified.  If neither
         * an ASCII file nor a variable output was specified by the user,
         * print the requested value to kstdout.
         */
        if (clui_info->o_flag)
           ascii_out = kfopen(clui_info->o_file, "w+");
        else if (!clui_info->var_flag)
           ascii_out = (kfile *) kstdout;

	if (ascii_out)
	{
           kfprintf(ascii_out, "%g\n", data[0]);
	   kfclose(ascii_out);
	}

	kfree(data);
	kpds_close_object(src_obj);
/* -main_before_lib_call_end */

/* -main_library_call */
/* -main_library_call_end */

/* -main_after_lib_call */
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kprval_usage_additions
| 
|       Purpose: Prints usage additions in kprval_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kprval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kprval_usage_additions(void)
{
	kfprintf(kstderr, "\tPrint Data Value to Parser and/or Concatenate to File\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kprval_free_args
| 
|       Purpose: Frees CLUI struct allocated in kprval_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kprval
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kprval_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->var_string);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
