 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for klinearop
   >>>> 
   >>>>    Written By: Jonio Roberto de Hollanda Cavalcanti, Ramiro Jordan
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 13, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _klinearop_h_
#define _klinearop_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include <kdatamanip/kdatamanip.h>
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/klinearop/uis/klinearop.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input object filename  (required infile)
 */
char	*i1_file;	/* Input object filename  FILENAME */
int	 i1_flag;	/* Input object filename  FLAG */

/*
 *  Input kernel filename (required infile)
 */
char	*i2_file;	/* Input kernel filename FILENAME */
int	 i2_flag;	/* Input kernel filename FLAG */

/*
 *  output object filename (required outfile)
 */
char	*o_file;	/* output object filename FILENAME */
int	 o_flag;	/* output object filename FLAG */

/*----- required ME group ----*/
	/*---- nested optional MI group ----*/
/*
 *  If flag is set, pad object (optional flag)
 */
int	 l_flag;  	/* If flag is set, pad object FLAG */

/*
 *  Real part of pad constant (optional double)
 */
double	 real_double;	/* Real part of pad constant DOUBLE */
int	 real_flag;   	/* Real part of pad constant FLAG */

/*
 *  Imaginary part of pad constant (optional double)
 */
double	 imag_double;	/* Imaginary part of pad constant DOUBLE */
int	 imag_flag;   	/* Imaginary part of pad constant FLAG */

/*
 *  Determine size of output (def: truncate) (optional logical)
 */
int	 size_logic;	/* Determine size of output (def: truncate) LOGIC */
int	 size_flag;  	/* Determine size of output (def: truncate) FLAG */

	/*-- nested optional MI group end --*/

/*
 *  If flag is set, do not pad object (optional flag)
 */
int	 c_flag;  	/* If flag is set, do not pad object FLAG */

/*-- required ME group end ---*/

/*----- required   group ----*/
/*
 *  Perform operation in the width direction. (optional flag)
 */
int	 w_flag;  	/* Perform operation in the width direction. FLAG */

/*
 *  Perform operation in the height direction. (optional flag)
 */
int	 h_flag;  	/* Perform operation in the height direction. FLAG */

/*
 *  Perform operation in the depth direction (optional flag)
 */
int	 d_flag;  	/* Perform operation in the depth direction FLAG */

/*
 *  Perform operation in the time direction. (optional flag)
 */
int	 t_flag;  	/* Perform operation in the time direction. FLAG */

/*
 *  Perform operation in the elements direction. (optional flag)
 */
int	 e_flag;  	/* Perform operation in the elements direction. FLAG */

/*-- required   group end ---*/

/*
 *  Kernel reflection (def: convolution) (optional logical)
 */
int	 flip_logic;	/* Kernel reflection (def: convolution) LOGIC */
int	 flip_flag;  	/* Kernel reflection (def: convolution) FLAG */

/*
 *  Upcast data type for processing. (optional flag)
 */
int	 upcast_flag;  	/* Upcast data type for processing. FLAG */

/*
 *  Width location of kernel origin (optional integer)
 */
int	 w0_int; 	/* Width location of kernel origin INT */
int	 w0_flag;	/* Width location of kernel origin FLAG */

/*
 *  Height location of kernel origin (optional integer)
 */
int	 h0_int; 	/* Height location of kernel origin INT */
int	 h0_flag;	/* Height location of kernel origin FLAG */

/*
 *  Depth location of kernel origin (optional integer)
 */
int	 d0_int; 	/* Depth location of kernel origin INT */
int	 d0_flag;	/* Depth location of kernel origin FLAG */

/*
 *  Time location of kernel origin (optional integer)
 */
int	 t0_int; 	/* Time location of kernel origin INT */
int	 t0_flag;	/* Time location of kernel origin FLAG */

/*
 *  Element location of kernel origin (optional integer)
 */
int	 e0_int; 	/* Element location of kernel origin INT */
int	 e0_flag;	/* Element location of kernel origin FLAG */

/*
 *  Sub-object width position. (optional integer)
 */
int	 wp_int; 	/* Sub-object width position. INT */
int	 wp_flag;	/* Sub-object width position. FLAG */

/*
 *  Sub-object width size. (optional integer)
 */
int	 ws_int; 	/* Sub-object width size. INT */
int	 ws_flag;	/* Sub-object width size. FLAG */

/*
 *  Sub-object height position. (optional integer)
 */
int	 hp_int; 	/* Sub-object height position. INT */
int	 hp_flag;	/* Sub-object height position. FLAG */

/*
 *  Sub-object height size. (optional integer)
 */
int	 hs_int; 	/* Sub-object height size. INT */
int	 hs_flag;	/* Sub-object height size. FLAG */

/*
 *  Sub-object depth position. (optional integer)
 */
int	 dp_int; 	/* Sub-object depth position. INT */
int	 dp_flag;	/* Sub-object depth position. FLAG */

/*
 *  Sub-object depth size. (optional integer)
 */
int	 ds_int; 	/* Sub-object depth size. INT */
int	 ds_flag;	/* Sub-object depth size. FLAG */

/*
 *  Sub-object time position. (optional integer)
 */
int	 tp_int; 	/* Sub-object time position. INT */
int	 tp_flag;	/* Sub-object time position. FLAG */

/*
 *  Sub-object time size. (optional integer)
 */
int	 ts_int; 	/* Sub-object time size. INT */
int	 ts_flag;	/* Sub-object time size. FLAG */

/*
 *  Sub-object elements position. (optional integer)
 */
int	 ep_int; 	/* Sub-object elements position. INT */
int	 ep_flag;	/* Sub-object elements position. FLAG */

/*
 *  Sub-object elements size. (optional integer)
 */
int	 es_int; 	/* Sub-object elements size. INT */
int	 es_flag;	/* Sub-object elements size. FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void klinearop_get_args PROTO((kform *));
void klinearop_usage_additions PROTO((void));
void klinearop_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
