 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kkmeans.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kkmeans_get_args
| 
|       Purpose: Gets command line args for kkmeans
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kkmeans
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kkmeans_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kkmeans is out of sync with arguments specified in kkmeans's *.pane file; please rerun ghostwriter on kkmeans.";


	/*
	 * allocate the kkmeans structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "map",
			  &(clui_info->map_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "spectrum",
			  &(clui_info->spectrum_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "n",
			  &(clui_info->n_int),
			  &(clui_info->n_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "k",
			  &(clui_info->k_int),
			  &(clui_info->k_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o1",
			  &(clui_info->o1_file),
			  &(clui_info->o1_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o2",
			  &(clui_info->o2_file),
			  &(clui_info->o2_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o3",
			  &(clui_info->o3_file),
			  &(clui_info->o3_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o4",
			  &(clui_info->o4_file),
			  &(clui_info->o4_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o5",
			  &(clui_info->o5_file),
			  &(clui_info->o5_flag))))
	{
	    kerror(NULL, "kkmeans_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



