 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kkmeans
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kkmeans.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Perform K-Means Clustering
|
|       Purpose: main program for kkmeans
|
|         Input:
|		char *clui_info->i1_file; {input data object}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->o1_file; {cluster number output object}
|		int   clui_info->o1_flag; {TRUE if -o1 specified}
|
|		char *clui_info->i2_file; {cluster center input object}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		int clui_info->map_flag; {TRUE if -map specified}
|
|		int clui_info->spectrum_flag; {TRUE if -spectrum specified}
|
|		int clui_info->n_int; {max number of iterations}
|		int clui_info->n_flag; {TRUE if -n specified}
|
|		int clui_info->k_int; {number of clusters}
|		int clui_info->k_flag; {TRUE if -k specified}
|
|		char *clui_info->o2_file; {cluster center output object}
|		int   clui_info->o2_flag; {TRUE if -o2 specified}
|
|		char *clui_info->o3_file; {cluster variance output object}
|		int   clui_info->o3_flag; {TRUE if -o3 specified}
|
|		char *clui_info->o4_file; {Cluster membership count output}
|		int   clui_info->o4_flag; {TRUE if -o4 specified}
|
|		char *clui_info->o5_file; {K-means statistics output (ASCII)}
|		int   clui_info->o5_flag; {TRUE if -o5 specified}
|
|        Output:
|       Returns:
|
|    Written By: Scott Wilson (stolen from the K1.5 vkmeans program, which was
written by Tom Sauer and Charlie Gage, with assistance from
Dr. Don Hush, UNM/EECE Dept.)
|          Date: Apr 15, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
kobject in_obj1,in_obj2,out_obj1,out_obj2,out_obj3,out_obj4;
kfile *statsfile;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kkmeans_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kkmeans",
		kkmeans_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kkmeans_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /* Handle required argmuents */
        if ((out_obj1 = kpds_open_output_object(clui_info->o1_file))
                == KOBJECT_INVALID)
          {
            kerror("kkmeans","main", "Cannot open output object.");
            kexit(KEXIT_FAILURE);
          }

        if ((in_obj1 = kpds_open_input_object(clui_info->i1_file))
                == KOBJECT_INVALID)
          {
            kerror("kkmeans","main", "Cannot open input object.");
            kexit(KEXIT_FAILURE);
          }
        if (!kpds_copy_object_attr(in_obj1, out_obj1))
          {
            kerror("kkmeans","main",
              "Unable to copy attributes from input to output object.");
            kexit(KEXIT_FAILURE);
          }

        /* Handle optional input files */
        in_obj2 = NULL;
        if (clui_info->i2_flag)
          {
            if ((in_obj2 = kpds_open_input_object(clui_info->i2_file))
                    == KOBJECT_INVALID)
              {
                kerror("kkmeans","main", "Cannot open input object.");
                kexit(KEXIT_FAILURE);
              }
          }

        /* Handle optional output files */
        out_obj2 = NULL;
        if (clui_info->o2_flag)
          {
            if ((out_obj2 = kpds_open_output_object(clui_info->o2_file))
                    == KOBJECT_INVALID)
              {
                kerror("kkmeans","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj1, out_obj2))
              {
                kerror("kkmeans","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }

        out_obj3 = NULL;
        if (clui_info->o3_flag)
          {
            if ((out_obj3 = kpds_open_output_object(clui_info->o3_file))
                    == KOBJECT_INVALID)
              {
                kerror("kkmeans","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj1, out_obj3))
              {
                kerror("kkmeans","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }

        out_obj4 = NULL;
        if (clui_info->o4_flag)
          {
            if ((out_obj4 = kpds_open_output_object(clui_info->o4_file))
                    == KOBJECT_INVALID)
              {
                kerror("kkmeans","main", "Cannot open output object.");
                kexit(KEXIT_FAILURE);
              }
            if (!kpds_copy_object_attr(in_obj1, out_obj4))
              {
                kerror("kkmeans","main",
                  "Unable to copy attributes from input to output object.");
                kexit(KEXIT_FAILURE);
              }
          }

        statsfile = NULL;
        if (clui_info->o5_flag)
          {
            statsfile = kfopen(clui_info->o5_file, "w");
          }
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!lkkmeans(in_obj1,
                      in_obj2,
                      clui_info->n_int,
                      clui_info->k_int,
                      clui_info->map_flag,
                      clui_info->spectrum_flag,
                      out_obj1,
                      out_obj2,
                      out_obj3,
                      out_obj4,
                      statsfile)) kexit(KEXIT_FAILURE);
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output objects and write */
        if (!kpds_set_attribute(out_obj1,KPDS_HISTORY,kpds_history_string()))
          {
            kerror("kkmeans","main","Unable to set history on output object");
            kexit(KEXIT_FAILURE);
          }
        kpds_close_object(out_obj1);
        kpds_close_object(in_obj1);

        if (clui_info->o2_flag)
          {
            if(!kpds_set_attribute(out_obj2,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("kkmeans","main",
                       "Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(out_obj2);
          }
        if (clui_info->o3_flag)
          {
            if(!kpds_set_attribute(out_obj3,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("kkmeans","main",
                       "Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(out_obj3);
          } 
        if (clui_info->o4_flag)
          {
            if(!kpds_set_attribute(out_obj4,KPDS_HISTORY,kpds_history_string()))
              {
                kerror("kkmeans","main",
                       "Unable to set history on output object");
                kexit(KEXIT_FAILURE);
              }
            kpds_close_object(out_obj4);
          } 
        if (clui_info->o5_flag) kfclose(statsfile);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kkmeans_usage_additions
| 
|       Purpose: Prints usage additions in kkmeans_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kkmeans
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kkmeans_usage_additions(void)
{
	kfprintf(kstderr, "\tPerform K-Means Clustering\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kkmeans_free_args
| 
|       Purpose: Frees CLUI struct allocated in kkmeans_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kkmeans
|          Date: Apr 15, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kkmeans_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->o1_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->o2_file);
	kfree(clui_info->o3_file);
	kfree(clui_info->o4_file);
	kfree(clui_info->o5_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
