 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kinset.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kinset_get_args
| 
|       Purpose: Gets command line args for kinset
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kinset
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kinset_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kinset is out of sync with arguments specified in kinset's *.pane file; please rerun ghostwriter on kinset.";


	/*
	 * allocate the kinset structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "insetvalid",
			  &(clui_info->insetvalid_logic),
			  &(clui_info->insetvalid_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "real",
			  &(clui_info->real_double),
			  &(clui_info->real_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "imag",
			  &(clui_info->imag_double),
			  &(clui_info->imag_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_logical(pane, "padvalid",
			  &(clui_info->padvalid_logic),
			  &(clui_info->padvalid_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "mapping", KVF_LIST_LABEL,
			  &(clui_info->mapping_label),
			  &(clui_info->mapping_flag)) &&
	      kclui_get_value(pane, "mapping", KVF_LIST_VAL,
			  &(clui_info->mapping_list),
			  &(clui_info->mapping_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "attr",
			  &(clui_info->attr_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "woff",
			  &(clui_info->woff_int),
			  &(clui_info->woff_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hoff",
			  &(clui_info->hoff_int),
			  &(clui_info->hoff_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "doff",
			  &(clui_info->doff_int),
			  &(clui_info->doff_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "toff",
			  &(clui_info->toff_int),
			  &(clui_info->toff_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "eoff",
			  &(clui_info->eoff_int),
			  &(clui_info->eoff_flag))))
	{
	    kerror(NULL, "kinset_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



