 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kimpulse.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kimpulse_get_args
| 
|       Purpose: Gets command line args for kimpulse
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimpulse
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kimpulse_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kimpulse is out of sync with arguments specified in kimpulse's *.pane file; please rerun ghostwriter on kimpulse.";


	/*
	 * allocate the kimpulse structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wnum",
			  &(clui_info->wnum_int),
			  &(clui_info->wnum_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hnum",
			  &(clui_info->hnum_int),
			  &(clui_info->hnum_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dnum",
			  &(clui_info->dnum_int),
			  &(clui_info->dnum_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tnum",
			  &(clui_info->tnum_int),
			  &(clui_info->tnum_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esize",
			  &(clui_info->esize_int),
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "enum",
			  &(clui_info->enum_int),
			  &(clui_info->enum_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "wsp",
			  &(clui_info->wsp_int),
			  &(clui_info->wsp_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "woff",
			  &(clui_info->woff_int),
			  &(clui_info->woff_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsp",
			  &(clui_info->hsp_int),
			  &(clui_info->hsp_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hoff",
			  &(clui_info->hoff_int),
			  &(clui_info->hoff_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsp",
			  &(clui_info->dsp_int),
			  &(clui_info->dsp_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "doff",
			  &(clui_info->doff_int),
			  &(clui_info->doff_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsp",
			  &(clui_info->tsp_int),
			  &(clui_info->tsp_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "toff",
			  &(clui_info->toff_int),
			  &(clui_info->toff_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esp",
			  &(clui_info->esp_int),
			  &(clui_info->esp_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "eoff",
			  &(clui_info->eoff_int),
			  &(clui_info->eoff_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "fgreal",
			  &(clui_info->fgreal_double),
			  &(clui_info->fgreal_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "bgreal",
			  &(clui_info->bgreal_double),
			  &(clui_info->bgreal_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "fgimag",
			  &(clui_info->fgimag_double),
			  &(clui_info->fgimag_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "bgimag",
			  &(clui_info->bgimag_double),
			  &(clui_info->bgimag_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kimpulse_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



