 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kimportasc.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kimportasc_get_args
| 
|       Purpose: Gets command line args for kimportasc
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimportasc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kimportasc_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kimportasc is out of sync with arguments specified in kimportasc's *.pane file; please rerun ghostwriter on kimportasc.";


	/*
	 * allocate the kimportasc structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_infile(pane, "i1",
			  &(clui_info->i1_file),
			  &(clui_info->i1_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_infile(pane, "i2",
			  &(clui_info->i2_file),
			  &(clui_info->i2_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "so",
			  &(clui_info->so_int),
			  &(clui_info->so_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "sf",
			  &(clui_info->sf_int),
			  &(clui_info->sf_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "segment",
			  &(clui_info->segment_string),
			  &(clui_info->segment_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dim",
			  &(clui_info->dim_int),
			  &(clui_info->dim_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "index",
			  &(clui_info->index_string),
			  &(clui_info->index_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_string(pane, "size",
			  &(clui_info->size_string),
			  &(clui_info->size_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kimportasc_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



