 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kimportasc
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kimportasc.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Import ASCII Data File to Data Segment
|
|       Purpose: main program for kimportasc
|
|         Input:
|		char *clui_info->i1_file; {ASCII input data file containing new data segment}
|		int   clui_info->i1_flag; {TRUE if -i1 specified}
|
|		char *clui_info->size_string; {This is a string containing the size of the segment in the index order specified , 40 32 32 1 1 will be a 5D segment that is 40x32x32x1x1}
|		int   clui_info->size_flag; {TRUE if -size specified}
|
|		char *clui_info->o_file; {output data object}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		char *clui_info->i2_file; {data object input to insert the new segment into}
|		int   clui_info->i2_flag; {TRUE if -i2 specified}
|
|		int clui_info->so_int; {starting point in ASCII input file to start importing at}
|		int clui_info->so_flag; {TRUE if -so specified}
|
|		int clui_info->sf_int; {number of points in ASCII file to skip between reads}
|		int clui_info->sf_flag; {TRUE if -sf specified}
|
|		char *clui_info->segment_string; {the name of the segment to insert the ASCII data into}
|		int   clui_info->segment_flag; {TRUE if -segment specified}
|
|		int clui_info->dim_int; {dimension of the segment}
|		int clui_info->dim_flag; {TRUE if -dim specified}
|
|		int   clui_info->type_list; {data type}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|		char *clui_info->index_string; {index order of the segment}
|		int   clui_info->index_flag; {TRUE if -index specified}
|
|        Output:
|       Returns:
|
|    Written By: John M. Salas, Donna Koechner, Jeremy Worley & John Rasure
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        char    **size_strings;
	int     *size_vector, count, i;
        kobject source_viff = KOBJECT_INVALID, destination_object;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kimportasc_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kimportasc",
		kimportasc_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kimportasc_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Instantiate objects.
         */
        if ( clui_info->i2_flag &&
	     (source_viff = kdms_open(clui_info->i2_file,
                                         KOBJ_READ)) == NULL) {
           kerror("kimportasc", "main", "Failed to open VIFF input object");
           kexit(KEXIT_FAILURE);
        }

        if ( (destination_object = kdms_open(clui_info->o_file,
                                             KOBJ_WRITE)) == NULL) {
           kerror("kimportasc", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
	/*
	 * Parse the size string into a integer array.
	 */
        size_strings =
           kparse_string_delimit(clui_info->size_string,
                                 " ", KDELIM_CLEAN, &count);

        if ( count != clui_info->dim_int ) {
           kerror("kimportasc", "main", 
		  "Number of size values entered does not match "
		  "specified dimensionality.");
           kexit(KEXIT_FAILURE);
        }

        size_vector = (int *) kmalloc(sizeof(int) *
				      kmax(5, clui_info->dim_int));

        for ( i = 0 ; i < count ; i ++ ) {
	   ksscanf(size_strings[i], "%d", &size_vector[i]);
	   kfree(size_strings[i]);
        }

	for ( i = count ; i < 5 ; i++ ) {
	   size_vector[i] = 1;
	}

	if ( !lkimportasc(clui_info->i1_file, source_viff,
			     clui_info->segment_string,
			     clui_info->dim_int,
			     clui_info->index_string,
			     size_vector,
			     clui_info->type_label,
			     clui_info->so_int,
			     clui_info->sf_int, destination_object) ) {
	   kfree(size_vector);
	   kexit(KEXIT_FAILURE);
	}
/* -main_library_call_end */

/* -main_after_lib_call */
	kfree(size_vector);

        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kimportasc", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kimportasc_usage_additions
| 
|       Purpose: Prints usage additions in kimportasc_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimportasc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kimportasc_usage_additions(void)
{
	kfprintf(kstderr, "\tImport ASCII Data File to Data Segment\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kimportasc_free_args
| 
|       Purpose: Frees CLUI struct allocated in kimportasc_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kimportasc
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kimportasc_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i1_file);
	kfree(clui_info->size_string);
	kfree(clui_info->o_file);
	kfree(clui_info->i2_file);
	kfree(clui_info->segment_string);
	kfree(clui_info->type_label);
	kfree(clui_info->index_string);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
