 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kgsin
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kgsin.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Generate Object Containing Sinusoidal Value Data
|
|       Purpose: main program for kgsin
|
|         Input:
|		char *clui_info->o_file; {Output file containing sinusoidal value data}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Required M.E. group:
|		    M.I. group:
|			int clui_info->sin1_flag; {TRUE if -sin1 specified}
|
|			double clui_info->ampl_double; {Maximum level of output}
|			int    clui_info->ampl_flag; {TRUE if -ampl specified}
|
|		    M.I. group:
|			int clui_info->sin5_flag; {TRUE if -sin5 specified}
|
|			double clui_info->wampl_double; {Amplitude along the width direction}
|			int    clui_info->wampl_flag; {TRUE if -wampl specified}
|
|			double clui_info->hampl_double; {Amplitude along the height direction}
|			int    clui_info->hampl_flag; {TRUE if -hampl specified}
|
|			double clui_info->dampl_double; {Amplitude along the depth direction}
|			int    clui_info->dampl_flag; {TRUE if -dampl specified}
|
|			double clui_info->tampl_double; {Amplitude along the time direction}
|			int    clui_info->tampl_flag; {TRUE if -tampl specified}
|
|			double clui_info->eampl_double; {Amplitude along the element direction}
|			int    clui_info->eampl_flag; {TRUE if -eampl specified}
|
|		int clui_info->wsize_int; {Width size of sinusoidal value data}
|		int clui_info->wsize_flag; {TRUE if -wsize specified}
|
|		int clui_info->hsize_int; {Height size of sinusoidal value data}
|		int clui_info->hsize_flag; {TRUE if -hsize specified}
|
|		int clui_info->dsize_int; {Depth size of sinusoidal value data}
|		int clui_info->dsize_flag; {TRUE if -dsize specified}
|
|		int clui_info->tsize_int; {Time size of sinusoidal value data}
|		int clui_info->tsize_flag; {TRUE if -tsize specified}
|
|		int clui_info->esize_int; {Elements dimension size of sinusoidal value data}
|		int clui_info->esize_flag; {TRUE if -esize specified}
|
|		double clui_info->wnum_double; {Number of sine waves along width dimension}
|		int    clui_info->wnum_flag; {TRUE if -wnum specified}
|
|		double clui_info->wp_double; {Phase offset along width dimension}
|		int    clui_info->wp_flag; {TRUE if -wp specified}
|
|		double clui_info->hnum_double; {Number of sine waves along height dimension}
|		int    clui_info->hnum_flag; {TRUE if -hnum specified}
|
|		double clui_info->hp_double; {Phase offset along the height dimension}
|		int    clui_info->hp_flag; {TRUE if -hp specified}
|
|		double clui_info->dnum_double; {Number of sine waves along depth dimension}
|		int    clui_info->dnum_flag; {TRUE if -dnum specified}
|
|		double clui_info->dp_double; {Phase offset along depth dimension}
|		int    clui_info->dp_flag; {TRUE if -dp specified}
|
|		double clui_info->tnum_double; {Number of sine waves along time dimension}
|		int    clui_info->tnum_flag; {TRUE if -tnum specified}
|
|		double clui_info->tp_double; {Phase Offset for time dimension}
|		int    clui_info->tp_flag; {TRUE if -tp specified}
|
|		double clui_info->enum_double; {Number of sine waves along Elements Dimension}
|		int    clui_info->enum_flag; {TRUE if -enum specified}
|
|		double clui_info->ep_double; {Phase Offset in the elements dimension}
|		int    clui_info->ep_flag; {TRUE if -ep specified}
|
|		int   clui_info->type_list; {Data type of sinusoidal value data}
|		char *clui_info->type_label;
|		int   clui_info->type_flag; {TRUE if -type specified}
|
|        Output:
|       Returns:
|
|    Written By: Ashish Malhotra
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        kobject out_obj;
        int     type,sum,size;
        double  *amplitude;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kgsin_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kgsin",
		kgsin_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kgsin_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        if ((out_obj = kpds_open_output_object(clui_info->o_file))
		== KOBJECT_INVALID) 
        {
           kerror("kgsin", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
 
        type = kdatatype_to_define(clui_info->type_label);

        sum = (clui_info->sin5_flag) ? 1 : 0;

        size = (sum) ? 5 : 1;

        amplitude= (double *)kmalloc(size * sizeof(double));

        if (sum)
        {
           amplitude[0] = clui_info->wampl_double;
           amplitude[1] = clui_info->hampl_double;
           amplitude[2] = clui_info->dampl_double;
           amplitude[3] = clui_info->tampl_double;
           amplitude[4] = clui_info->eampl_double;
        }
        else
           amplitude[0] = clui_info->ampl_double;
/* -main_before_lib_call_end */

/* -main_library_call */
	if (!(lkgsin(clui_info->wsize_int, clui_info->hsize_int,
                clui_info->dsize_int, clui_info->tsize_int,
                clui_info->esize_int,sum,amplitude,
                clui_info->wnum_double,clui_info->hnum_double,
                clui_info->dnum_double,clui_info->tnum_double,
                clui_info->enum_double,clui_info->wp_double,
                clui_info->hp_double, clui_info->dp_double,
                clui_info->tp_double, clui_info->ep_double,
                type,out_obj)))
        {
           kfree(amplitude);
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
	/* add history to the output object */
	if (!kpds_set_attribute(out_obj, KPDS_HISTORY, kpds_history_string()))
	{
	   kerror("kgsin", "main", 
		  "Unable to set history on the destination object");
	   kexit(KEXIT_FAILURE);
	}

        kpds_close_object(out_obj);
        kfree(amplitude);
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kgsin_usage_additions
| 
|       Purpose: Prints usage additions in kgsin_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgsin
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgsin_usage_additions(void)
{
	kfprintf(kstderr, "\tGenerate Object Containing Sinusoidal Value Data\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kgsin_free_args
| 
|       Purpose: Frees CLUI struct allocated in kgsin_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgsin
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kgsin_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->o_file);
	kfree(clui_info->type_label);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
