 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

#include "kgnoise.h"
/*-----------------------------------------------------------
| 
|  Routine Name: kgnoise_get_args
| 
|       Purpose: Gets command line args for kgnoise
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kgnoise
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kgnoise_get_args(
    kform *pane)
{

	static char *sync_error_mesg = "Generated code for kgnoise is out of sync with arguments specified in kgnoise's *.pane file; please rerun ghostwriter on kgnoise.";


	/*
	 * allocate the kgnoise structure
	 */
	clui_info = (clui_info_struct *) 
	       kcalloc((unsigned)1, (unsigned) sizeof (clui_info_struct));

	if (!(kclui_get_int(pane, "wsize",
			  &(clui_info->wsize_int),
			  &(clui_info->wsize_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "hsize",
			  &(clui_info->hsize_int),
			  &(clui_info->hsize_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "dsize",
			  &(clui_info->dsize_int),
			  &(clui_info->dsize_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "tsize",
			  &(clui_info->tsize_int),
			  &(clui_info->tsize_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_int(pane, "esize",
			  &(clui_info->esize_int),
			  &(clui_info->esize_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_value(pane, "type", KVF_LIST_LABEL,
			  &(clui_info->type_label),
			  &(clui_info->type_flag)) &&
	      kclui_get_value(pane, "type", KVF_LIST_VAL,
			  &(clui_info->type_list),
			  &(clui_info->type_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_outfile(pane, "o",
			  &(clui_info->o_file),
			  &(clui_info->o_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "gauss",
			  &(clui_info->gauss_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "gmean",
			  &(clui_info->gmean_double),
			  &(clui_info->gmean_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "gvar",
			  &(clui_info->gvar_double),
			  &(clui_info->gvar_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "ray",
			  &(clui_info->ray_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "rvar",
			  &(clui_info->rvar_double),
			  &(clui_info->rvar_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "unif",
			  &(clui_info->unif_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "umax",
			  &(clui_info->umax_double),
			  &(clui_info->umax_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "umin",
			  &(clui_info->umin_double),
			  &(clui_info->umin_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "poiss",
			  &(clui_info->poiss_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "ptime",
			  &(clui_info->ptime_double),
			  &(clui_info->ptime_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "pvar",
			  &(clui_info->pvar_double),
			  &(clui_info->pvar_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_flag(pane, "exp",
			  &(clui_info->exp_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}

	if (!(kclui_get_double(pane, "evar",
			  &(clui_info->evar_double),
			  &(clui_info->evar_flag))))
	{
	    kerror(NULL, "kgnoise_get_args", sync_error_mesg);
	    kexit(KEXIT_FAILURE);
	}


}



