 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kfft
   >>>> 
   >>>>    Written By: Scott Wilson, Ashish Malhotra
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 14, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kfft_h_
#define _kfft_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kfft/uis/kfft.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  complex input object (required infile)
 */
char	*i_file;	/* complex input object FILENAME */
int	 i_flag;	/* complex input object FLAG */

/*
 *  complex output object (required outfile)
 */
char	*o_file;	/* complex output object FILENAME */
int	 o_flag;	/* complex output object FLAG */

/*----- required   group ----*/
/*
 *  if set, FFT is taken along the width dimension (optional flag)
 */
int	 w_flag;  	/* if set, FFT is taken along the width dimension FLAG */

/*
 *  if set, FFT is taken along the height dimension (optional flag)
 */
int	 h_flag;  	/* if set, FFT is taken along the height dimension FLAG */

/*
 *  if set, FFT is taken along the depth dimension (optional flag)
 */
int	 d_flag;  	/* if set, FFT is taken along the depth dimension FLAG */

/*
 *  if set, FFT is taken along the time dimension (optional flag)
 */
int	 t_flag;  	/* if set, FFT is taken along the time dimension FLAG */

/*
 *  if set, FFT is taken along the element dimension (optional flag)
 */
int	 e_flag;  	/* if set, FFT is taken along the element dimension FLAG */

/*-- required   group end ---*/

/*
 *  FFT direction (0 is forward, 1 is inverse) (optional logical)
 */
int	 dir_logic;	/* FFT direction (0 is forward, 1 is inverse) LOGIC */
int	 dir_flag;  	/* FFT direction (0 is forward, 1 is inverse) FLAG */

/*
 *  select to center (1) or not to center (0) the transform (optional logical)
 */
int	 center_logic;	/* select to center (1) or not to center (0) the transform LOGIC */
int	 center_flag;  	/* select to center (1) or not to center (0) the transform FLAG */

/*
 * scale FFT by 1, 1/N or 1/sqrt(N) (Optional flag toggle)
 *	1 (Scale the output data by unity)
 *	2 (Scale output data by 1/N per transform axis)
 *	3 (Scale output data by 1/sqrt(N) per transform axis),
 */
int	 scale_toggle;		/* scale FFT by 1, 1/N or 1/sqrt(N) FLAG TOGGLE */
int	 scale_flag;		/* scale FFT by 1, 1/N or 1/sqrt(N) FLAG */

/*
 *  Output object data type (Optional cycle)
 */
int	 type_cycle;	/* Output object data type CYCLE INDEX */
char	 *type_label;	/* Output object data type CYCLE LABEL */
int	 type_flag;	/* Output object data type FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kfft_get_args PROTO((kform *));
void kfft_usage_additions PROTO((void));
void kfft_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
