 /*
  * Khoros: $Id$
  */

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>>       Purpose: Include file for kextract
   >>>> 
   >>>>    Written By: Donna Koechner and Mark Young
   >>>> 
   >>>> Modifications: 
   >>>> 
   >>>>          Date: Apr 08, 1995
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#ifndef _kextract_h_
#define _kextract_h_

        /*-------------------------------------*
         |       #includes
        ---------------------------------------*/

#include <datamanip.h>

/* -include_includes */
#include "kdatamanip/kdatamanip.h"
/* -include_includes_end */


        /*-------------------------------------*
         |       #defines
        ---------------------------------------*/

/* -include_defines */
/* -include_defines_end */

#define PANEPATH "$DATAMANIP/objects/kroutine/kextract/uis/kextract.pane"
        /*-------------------------------------*
         |       typedefs
        ---------------------------------------*/

typedef struct _clui_info_struct {

/*
 *  Input object (required infile)
 */
char	*i_file;	/* Input object FILENAME */
int	 i_flag;	/* Input object FLAG */

/*
 *  Resulting output region (required outfile)
 */
char	*o_file;	/* Resulting output region FILENAME */
int	 o_flag;	/* Resulting output region FLAG */

/*
 *  Specifies the region width (optional integer)
 */
int	 wsize_int; 	/* Specifies the region width INT */
int	 wsize_flag;	/* Specifies the region width FLAG */

/*
 *  Specifies the region height (optional integer)
 */
int	 hsize_int; 	/* Specifies the region height INT */
int	 hsize_flag;	/* Specifies the region height FLAG */

/*
 *  Specifies the region depth (optional integer)
 */
int	 dsize_int; 	/* Specifies the region depth INT */
int	 dsize_flag;	/* Specifies the region depth FLAG */

/*
 *  Specifies the region size on time dimension (optional integer)
 */
int	 tsize_int; 	/* Specifies the region size on time dimension INT */
int	 tsize_flag;	/* Specifies the region size on time dimension FLAG */

/*
 *  Specifies the region size on elements dimension (optional integer)
 */
int	 esize_int; 	/* Specifies the region size on elements dimension INT */
int	 esize_flag;	/* Specifies the region size on elements dimension FLAG */

/*
 *  Specifies origin of region on width dimension (optional integer)
 */
int	 woff_int; 	/* Specifies origin of region on width dimension INT */
int	 woff_flag;	/* Specifies origin of region on width dimension FLAG */

/*
 *  Specifies origin of region on height dimension (optional integer)
 */
int	 hoff_int; 	/* Specifies origin of region on height dimension INT */
int	 hoff_flag;	/* Specifies origin of region on height dimension FLAG */

/*
 *  Specifies origin of region on depth dimension (optional integer)
 */
int	 doff_int; 	/* Specifies origin of region on depth dimension INT */
int	 doff_flag;	/* Specifies origin of region on depth dimension FLAG */

/*
 *  Specifies origin of region on time dimension (optional integer)
 */
int	 toff_int; 	/* Specifies origin of region on time dimension INT */
int	 toff_flag;	/* Specifies origin of region on time dimension FLAG */

/*
 *  Specifies origin of region on elements dimension (optional integer)
 */
int	 eoff_int; 	/* Specifies origin of region on elements dimension INT */
int	 eoff_flag;	/* Specifies origin of region on elements dimension FLAG */

/*
 *  Record region origin (Subobject Position) in output (optional logical)
 */
int	 subpos_logic;	/* Record region origin (Subobject Position) in output LOGIC */
int	 subpos_flag;  	/* Record region origin (Subobject Position) in output FLAG */

} clui_info_struct;

/* -include_typedefs */
/* -include_typedefs_end */


        /*-------------------------------------*
         |       global variable declarations
        ---------------------------------------*/

extern clui_info_struct *clui_info;
/* -include_variables */
/* -include_variables_end */


        /*-------------------------------------*
         |       macros
        ---------------------------------------*/

/* -include_macros */
/* -include_macros_end */

        /*-------------------------------------*
         |       routine definitions
        ---------------------------------------*/

void main PROTO((int, char **, char **));
void kextract_get_args PROTO((kform *));
void kextract_usage_additions PROTO((void));
void kextract_free_args PROTO((int, kaddr));

/* -include_routines */
/* -include_routines_end */

#endif
