 /*
  * Khoros: $Id$
  */

#if !defined(__lint) && !defined(__CODECENTER__)
static char rcsid[] = "Khoros: $Id$";
#endif

 /*
  * $Log$
  */

/*
 * Copyright (C) 1993, 1994, 1995, Khoral Research, Inc., ("KRI").
 * All rights reserved.  See $BOOTSTRAP/repos/license/License or run klicense.
 */

/* >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<<
   >>>> 
   >>>> 	Main program for kcpseg
   >>>> 
   >>>>  Private: 
   >>>> 	main
   >>>> 
   >>>>   Static: 
   >>>>   Public: 
   >>>> 
   >>>>>>>>>>>>>>>>>>>>>>>>>>>>> <<<<<<<<<<<<<<<<<<<<<<<<<< */


#include "kcpseg.h"

clui_info_struct *clui_info = NULL;

/*-----------------------------------------------------------
|
|  Routine Name: main() - Copy Selected Data Segments from Input
|
|       Purpose: main program for kcpseg
|
|         Input:
|		char *clui_info->i_file; {input file}
|		int   clui_info->i_flag; {TRUE if -i specified}
|
|		char *clui_info->o_file; {output file}
|		int   clui_info->o_flag; {TRUE if -o specified}
|
|		Loose group:
|		    int clui_info->val_flag; {TRUE if -val specified}
|
|		    int clui_info->map_flag; {TRUE if -map specified}
|
|		    int clui_info->mask_flag; {TRUE if -mask specified}
|
|		    int clui_info->loc_flag; {TRUE if -loc specified}
|
|		    int clui_info->time_flag; {TRUE if -time specified}
|
|		    char *clui_info->segment_string; {Perform operation on user specified segment}
|		    int   clui_info->segment_flag; {TRUE if -segment specified}
|
|        Output:
|       Returns:
|
|    Written By: John M. Salas & Donna Koechner
|          Date: Apr 08, 1995
| Modifications:
|
------------------------------------------------------------*/

void main(
   int  argc,
   char **argv,
   char **envp)
{

	kform  *pane;         /* form tree representing *.pane file */
/* -main_variable_list */
        char    *segment_list=NULL;
        int     copy_all = FALSE;
        kobject source_object=NULL, destination_object=NULL;
/* -main_variable_list_end */

	khoros_initialize(argc, argv, envp, "DATAMANIP");
	kexit_handler(kcpseg_free_args, NULL);

/* -main_get_args_call */
	pane = kgen_initialize(PANEPATH, KGEN_KROUTINE, "DATAMANIP", "kcpseg",
		kcpseg_usage_additions);

	if (!(kclui_check_args()))
	    kexit(KEXIT_FAILURE);
	kcpseg_get_args(pane);
	kvf_destroy_form(pane);
/* -main_get_args_call_end */

/* -main_before_lib_call */
        /*
         * Open objects.
         */
        if ((source_object = kdms_open(clui_info->i_file, KOBJ_READ))==NULL) {
           kerror("kcpseg", "main", "Failed to open input object");
           kexit(KEXIT_FAILURE);
        }
 
        if ((destination_object = kdms_open(clui_info->o_file,
                                            KOBJ_WRITE)) == NULL){
           kerror("kcpseg", "main", "Failed to open output object");
           kexit(KEXIT_FAILURE);
        }
/* -main_before_lib_call_end */

/* -main_library_call */
        /*
         * If the -segment option specified see if its value is "Copy All".
         * If it is copy all the segments.  If not create the segment_list.
         */
        if ( clui_info->segment_flag ) {
           if ( kstrstr(clui_info->segment_string, "Copy All") )
           {
              if ( !lkcpseg(source_object, NULL, destination_object) ) {
                 kexit(KEXIT_FAILURE);
              }
              copy_all = TRUE;
           }
           else {
              segment_list =
                kstring_cat(clui_info->segment_string, " ", NULL);
           }
        }
 
        /*
         * Now check for all the polymorphic segment if we did not
         * already try to copy all the data already and append them
         * to the segment_list.
         */
        if ( !copy_all && clui_info->val_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_VALUE, " ", NULL);
        }
 
        if ( !copy_all && clui_info->mask_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_MASK, " ", NULL);
        }
 
        if ( !copy_all && clui_info->map_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_MAP, " ", NULL);
        }
 
        if ( !copy_all && clui_info->loc_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_LOCATION, " ", NULL);
        }
 
        if ( !copy_all && clui_info->time_flag ) {
           segment_list =
                kstring_3cat(segment_list, KDMS_SEGMENT_TIME, " ", NULL);
        }
 
 
        /*
         * If we have not tried to copy all the segment, copy the segments on
         * the segment_list.
         */
        if ( !copy_all &&
             !lkcpseg(source_object,segment_list,destination_object) ) {
           kexit(KEXIT_FAILURE);
        }
/* -main_library_call_end */

/* -main_after_lib_call */
        /* add history to the output object */
        if (!kpds_set_attribute(destination_object, 
                                KPDS_HISTORY, kpds_history_string()))
        {
           kerror("kcpseg", "main", 
                  "Unable to set history on the destination object");
           kexit(KEXIT_FAILURE);
        }
/* -main_after_lib_call_end */


	kexit(KEXIT_SUCCESS);
}


/*-----------------------------------------------------------
| 
|  Routine Name: kcpseg_usage_additions
| 
|       Purpose: Prints usage additions in kcpseg_usage routine
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcpseg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
void kcpseg_usage_additions(void)
{
	kfprintf(kstderr, "\tCopy Selected Data Segments from Input\n");

/* -usage_additions */
/* -usage_additions_end */

}
/*-----------------------------------------------------------
| 
|  Routine Name: kcpseg_free_args
| 
|       Purpose: Frees CLUI struct allocated in kcpseg_get_args()
| 
|         Input: None
| 
|        Output: None
|    Written By: ghostwriter -oname kcpseg
|          Date: Apr 08, 1995
| Modifications: 
| 
------------------------------------------------------------*/
/* ARGSUSED */
void
kcpseg_free_args(
    int   status,
    kaddr client_data)
{

	/* do the wild and free thing */
	if (clui_info != NULL)
		{
	kfree(clui_info->i_file);
	kfree(clui_info->o_file);
		kfree(clui_info);
		}

/* -free_handler_additions */
/* -free_handler_additions_end */
}
